/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.store.properties.BorderProperty;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.ColorProxy;
import java.awt.Color;
import java.awt.Component;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class EtchedBorderProperty
extends BorderProperty
implements Externalizable {
    static final long serialVersionUID = -8742021440405641715L;
    public static final int VERSION = 2;
    private int m_type;
    private ColorProperty m_highlightColor = new ColorProperty("default");
    private ColorProperty m_shadowColor = new ColorProperty("default");
    static final /* synthetic */ boolean $assertionsDisabled;

    public EtchedBorderProperty() {
        this.setBorder(new EtchedBorder(0));
    }

    public EtchedBorderProperty(int n) {
        this.setBorder(new EtchedBorder(n));
    }

    public Border createBorder(Component component) {
        ColorProxy colorProxy = null;
        ColorProxy colorProxy2 = null;
        ColorProperty colorProperty = this.getHighlightColorProperty();
        if (!colorProperty.getColorKey().equals("default") && colorProperty.getColor() != null) {
            colorProxy = new ColorProxy(colorProperty);
        }
        if (!(colorProperty = this.getShadowColorProperty()).getColorKey().equals("default") && colorProperty.getColor() != null) {
            colorProxy2 = new ColorProxy(colorProperty);
        }
        EtchedBorder etchedBorder = new EtchedBorder(this.getEtchType(), colorProxy, colorProxy2);
        return this.createTitle(etchedBorder);
    }

    public int getEtchType() {
        return this.m_type;
    }

    public Color getHighlightColor() {
        return this.m_highlightColor.getColor();
    }

    public Color getShadowColor() {
        return this.m_shadowColor.getColor();
    }

    public ColorProperty getHighlightColorProperty() {
        return this.m_highlightColor;
    }

    public ColorProperty getShadowColorProperty() {
        return this.m_shadowColor;
    }

    public void setBorder(EtchedBorder etchedBorder) {
        this.m_type = etchedBorder.getEtchType();
    }

    public void setEtchType(int n) {
        this.m_type = n;
    }

    public void setHighlightColorProperty(ColorProperty colorProperty) {
        this.m_highlightColor = colorProperty;
    }

    public void setShadowColorProperty(ColorProperty colorProperty) {
        this.m_shadowColor = colorProperty;
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (object instanceof EtchedBorderProperty) {
            EtchedBorderProperty etchedBorderProperty = (EtchedBorderProperty)object;
            this.m_type = etchedBorderProperty.m_type;
            this.m_highlightColor = etchedBorderProperty.m_highlightColor;
            this.m_shadowColor = etchedBorderProperty.m_shadowColor;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.m_type = objectInput.readInt();
        if (n == 1) {
            this.m_highlightColor.setConstantColor((Color)objectInput.readObject());
            this.m_shadowColor.setConstantColor((Color)objectInput.readObject());
        } else {
            this.m_highlightColor.setValue((ColorProperty)objectInput.readObject());
            this.m_shadowColor.setValue((ColorProperty)objectInput.readObject());
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(2);
        objectOutput.writeInt(this.m_type);
        objectOutput.writeObject(this.m_highlightColor);
        objectOutput.writeObject(this.m_shadowColor);
    }

    public String toString() {
        return "ETCHED";
    }

    static {
        $assertionsDisabled = !EtchedBorderProperty.class.desiredAssertionStatus();
    }
}

