/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.base.$Preconditions;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import com.google.auto.value.processor.AnnotationOutput;
import com.google.auto.value.processor.JavaScanner;
import com.google.auto.value.processor.MissingTypeException;
import com.google.auto.value.processor.TypeMirrorSet;
import com.google.auto.value.processor.TypeSimplifier;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

final class TypeEncoder {
    private static final EncodingTypeVisitor ENCODING_TYPE_VISITOR = new EncodingTypeVisitor();
    private static final RawEncodingTypeVisitor RAW_ENCODING_TYPE_VISITOR = new RawEncodingTypeVisitor();

    private TypeEncoder() {
    }

    static String encode(TypeMirror type) {
        StringBuilder sb = new StringBuilder();
        return type.accept(ENCODING_TYPE_VISITOR, sb).toString();
    }

    static String encodeRaw(TypeMirror type) {
        StringBuilder sb = new StringBuilder();
        return type.accept(RAW_ENCODING_TYPE_VISITOR, sb).toString();
    }

    static String encodeWithAnnotations(TypeMirror type) {
        return TypeEncoder.encodeWithAnnotations(type, $ImmutableSet.of());
    }

    static String encodeWithAnnotations(TypeMirror type, Set<TypeMirror> excludedAnnotationTypes) {
        StringBuilder sb = new StringBuilder();
        return new AnnotatedEncodingTypeVisitor(excludedAnnotationTypes).visit2(type, sb).toString();
    }

    static String decode(String text, ProcessingEnvironment processingEnv, String packageName, TypeMirror baseType) {
        return TypeEncoder.decode(text, processingEnv.getElementUtils(), processingEnv.getTypeUtils(), packageName, baseType);
    }

    static String decode(String text, Elements elementUtils, Types typeUtils, String pkg, TypeMirror baseType) {
        TypeRewriter typeRewriter = new TypeRewriter(text, elementUtils, typeUtils, pkg, baseType);
        return typeRewriter.rewrite();
    }

    private static String className(DeclaredType declaredType) {
        return $MoreElements.asType(declaredType.asElement()).getQualifiedName().toString();
    }

    static String formalTypeParametersString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<");
        String sep = "";
        for (TypeParameterElement typeParameterElement : typeParameters) {
            sb.append(sep);
            sep = ", ";
            TypeEncoder.appendTypeParameterWithBounds(typeParameterElement, sb);
        }
        return sb.append(">").toString();
    }

    private static void appendTypeParameterWithBounds(TypeParameterElement typeParameter, StringBuilder sb) {
        TypeEncoder.appendAnnotations(typeParameter.getAnnotationMirrors(), sb);
        sb.append(typeParameter.getSimpleName());
        String sep = " extends ";
        for (TypeMirror typeMirror : typeParameter.getBounds()) {
            if (typeMirror.toString().equals("java.lang.Object")) continue;
            sb.append(sep);
            sep = " & ";
            sb.append(TypeEncoder.encode(typeMirror));
        }
    }

    private static void appendAnnotations(List<? extends AnnotationMirror> annotationMirrors, StringBuilder sb) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            sb.append(AnnotationOutput.sourceFormForAnnotation(annotationMirror)).append(" ");
        }
    }

    private static class TypeRewriter {
        private final String text;
        private final int textLength;
        private final JavaScanner scanner;
        private final Elements elementUtils;
        private final Types typeUtils;
        private final String packageName;
        private final TypeMirror baseType;

        TypeRewriter(String text, Elements elementUtils, Types typeUtils, String pkg, TypeMirror baseType) {
            this.text = text;
            this.textLength = text.length();
            this.scanner = new JavaScanner(text);
            this.elementUtils = elementUtils;
            this.typeUtils = typeUtils;
            this.packageName = pkg;
            this.baseType = baseType;
        }

        String rewrite() {
            int copyStart;
            Set<TypeMirror> referencedClasses = this.findReferencedClasses();
            TypeSimplifier typeSimplifier = new TypeSimplifier(this.elementUtils, this.typeUtils, this.packageName, referencedClasses, this.baseType);
            StringBuilder output = new StringBuilder();
            OptionalInt importMarker = this.findImportMarker();
            if (importMarker.isPresent()) {
                output.append(this.text, 0, importMarker.getAsInt());
                for (String toImport : typeSimplifier.typesToImport()) {
                    output.append("import ").append(toImport).append(";\n");
                }
                copyStart = this.scanner.tokenEnd(importMarker.getAsInt());
            } else {
                copyStart = 0;
            }
            int token = copyStart;
            while (token < this.textLength) {
                if (this.text.charAt(token) == '`') {
                    output.append(this.text, copyStart, token);
                    this.decode(output, typeSimplifier, token);
                    copyStart = this.scanner.tokenEnd(token);
                }
                token = this.scanner.tokenEnd(token);
            }
            output.append(this.text, copyStart, this.textLength);
            return output.toString();
        }

        private Set<TypeMirror> findReferencedClasses() {
            TypeMirrorSet classes = new TypeMirrorSet();
            int token = 0;
            while (token < this.textLength) {
                if (this.text.charAt(token) == '`' && !this.text.startsWith("`import`", token)) {
                    String className = this.classNameAt(token);
                    classes.add(this.classForName(className));
                }
                token = this.scanner.tokenEnd(token);
            }
            return classes;
        }

        private DeclaredType classForName(String className) {
            TypeElement typeElement = this.elementUtils.getTypeElement(className);
            $Preconditions.checkState(typeElement != null, "Could not find referenced class %s", (Object)className);
            return $MoreTypes.asDeclared(typeElement.asType());
        }

        private void decode(StringBuilder output, TypeSimplifier typeSimplifier, int token) {
            String className = this.classNameAt(token);
            DeclaredType type = this.classForName(className);
            String simplified = typeSimplifier.simplifiedClassName(type);
            switch (this.text.charAt(token + 1)) {
                case '\u00ab': {
                    int dot = simplified.lastIndexOf(46);
                    output.append(simplified.substring(0, dot + 1));
                    break;
                }
                case '\u00bb': {
                    int dot = simplified.lastIndexOf(46);
                    output.append(simplified.substring(dot + 1));
                    break;
                }
                default: {
                    output.append(simplified);
                }
            }
        }

        private OptionalInt findImportMarker() {
            int token = 0;
            while (token < this.textLength) {
                if (this.text.startsWith("`import`", token)) {
                    return OptionalInt.of(token);
                }
                token = this.scanner.tokenEnd(token);
            }
            return OptionalInt.empty();
        }

        private String classNameAt(int token) {
            $Preconditions.checkArgument(this.text.charAt(token) == '`');
            int end = this.scanner.tokenEnd(token) - 1;
            int t = token + 1;
            char c = this.text.charAt(t);
            if (c == '\u00ab' || c == '\u00bb') {
                ++t;
            }
            return this.text.substring(t, end);
        }
    }

    private static class AnnotatedEncodingTypeVisitor
    extends EncodingTypeVisitor {
        private final Set<TypeMirror> excludedAnnotationTypes;

        AnnotatedEncodingTypeVisitor(Set<TypeMirror> excludedAnnotationTypes) {
            this.excludedAnnotationTypes = excludedAnnotationTypes;
        }

        private void appendAnnotationsWithExclusions(List<? extends AnnotationMirror> annotations, StringBuilder sb) {
            if (annotations.isEmpty() || this.excludedAnnotationTypes.isEmpty()) {
                TypeEncoder.appendAnnotations(annotations, sb);
                return;
            }
            List includedAnnotations = annotations.stream().filter(a -> !this.excludedAnnotationTypes.contains(a.getAnnotationType())).collect(Collectors.toList());
            TypeEncoder.appendAnnotations(includedAnnotations, sb);
        }

        @Override
        public StringBuilder visitPrimitive(PrimitiveType type, StringBuilder sb) {
            this.appendAnnotationsWithExclusions(type.getAnnotationMirrors(), sb);
            return sb.append(type.getKind().toString().toLowerCase());
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable type, StringBuilder sb) {
            this.appendAnnotationsWithExclusions(type.getAnnotationMirrors(), sb);
            return sb.append(type.asElement().getSimpleName());
        }

        @Override
        public StringBuilder visitArray(ArrayType type, StringBuilder sb) {
            this.visit2(type.getComponentType(), sb);
            List<? extends AnnotationMirror> annotationMirrors = type.getAnnotationMirrors();
            if (!annotationMirrors.isEmpty()) {
                sb.append(" ");
                this.appendAnnotationsWithExclusions(annotationMirrors, sb);
            }
            return sb.append("[]");
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType type, StringBuilder sb) {
            List<? extends AnnotationMirror> annotationMirrors = type.getAnnotationMirrors();
            if (annotationMirrors.isEmpty()) {
                sb.append(this.declaredTypeName(type));
            } else {
                String className = TypeEncoder.className(type);
                sb.append("`\u00ab").append(className).append("`");
                this.appendAnnotationsWithExclusions(annotationMirrors, sb);
                sb.append("`\u00bb").append(className).append("`");
            }
            this.appendTypeArguments(type, sb);
            return sb;
        }
    }

    private static class RawEncodingTypeVisitor
    extends EncodingTypeVisitor {
        private RawEncodingTypeVisitor() {
        }

        @Override
        void appendTypeArguments(DeclaredType type, StringBuilder sb) {
        }
    }

    private static class EncodingTypeVisitor
    extends SimpleTypeVisitor8<StringBuilder, StringBuilder> {
        private EncodingTypeVisitor() {
        }

        StringBuilder visit2(TypeMirror type, StringBuilder sb) {
            if (type.getKind().equals((Object)TypeKind.DECLARED)) {
                return this.visitDeclared((DeclaredType)type, sb);
            }
            return (StringBuilder)this.visit(type, sb);
        }

        @Override
        protected StringBuilder defaultAction(TypeMirror type, StringBuilder sb) {
            return sb.append(type);
        }

        @Override
        public StringBuilder visitArray(ArrayType type, StringBuilder sb) {
            return this.visit2(type.getComponentType(), sb).append("[]");
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType type, StringBuilder sb) {
            sb.append(this.declaredTypeName(type));
            this.appendTypeArguments(type, sb);
            return sb;
        }

        String declaredTypeName(DeclaredType type) {
            return "`" + TypeEncoder.className(type) + "`";
        }

        void appendTypeArguments(DeclaredType type, StringBuilder sb) {
            List<? extends TypeMirror> arguments = type.getTypeArguments();
            if (!arguments.isEmpty()) {
                sb.append("<");
                String sep = "";
                for (TypeMirror typeMirror : arguments) {
                    sb.append(sep);
                    sep = ", ";
                    this.visit2(typeMirror, sb);
                }
                sb.append(">");
            }
        }

        @Override
        public StringBuilder visitWildcard(WildcardType type, StringBuilder sb) {
            sb.append("?");
            TypeMirror extendsBound = type.getExtendsBound();
            TypeMirror superBound = type.getSuperBound();
            if (superBound != null) {
                sb.append(" super ");
                this.visit2(superBound, sb);
            } else if (extendsBound != null) {
                sb.append(" extends ");
                this.visit2(extendsBound, sb);
            }
            return sb;
        }

        @Override
        public StringBuilder visitError(ErrorType t, StringBuilder p) {
            throw new MissingTypeException();
        }
    }
}

