/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildViewManager;
import com.intellij.build.SyncViewManager;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.frontend.split.BuildModelUtilsKt;
import com.intellij.platform.frontend.split.FrontendProcessInfo;
import com.jetbrains.rd.ide.model.BuildEventModel;
import com.jetbrains.rd.ide.model.StartBuildEventModel;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.ThinClientBuildModel;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J;\u0010\f\u001a\u00020\u0006\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/execution/frontend/split/ThinClientBuildModelListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/ThinClientBuildModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "syncFromModel", "T", "Lcom/intellij/build/AbstractViewManager;", "project", "Lcom/intellij/openapi/project/Project;", "signal", "Lcom/jetbrains/rd/util/reactive/IAsyncSignal;", "Lcom/jetbrains/rd/ide/model/BuildEventModel;", "releaseEventEditors", "Companion", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientBuildHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientBuildHost.kt\ncom/intellij/platform/execution/frontend/split/ThinClientBuildModelListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,63:1\n40#1,4:64\n40#1,4:68\n14#2:72\n*S KotlinDebug\n*F\n+ 1 ThinClientBuildHost.kt\ncom/intellij/platform/execution/frontend/split/ThinClientBuildModelListener\n*L\n33#1:64,4\n34#1:68,4\n61#1:72\n*E\n"})
public final class ThinClientBuildModelListener
implements SolutionExtListener<ThinClientBuildModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session2, @NotNull ThinClientBuildModel model) {
        ThinClientBuildModel model$iv;
        Project project$iv;
        Lifetime lifetime$iv;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (FrontendProcessInfo.INSTANCE.isController()) {
            this.releaseEventEditors(lifetime, (IAsyncSignal<BuildEventModel>)model.getBuildEvent());
            this.releaseEventEditors(lifetime, (IAsyncSignal<BuildEventModel>)model.getSyncEvent());
            return;
        }
        ThinClientBuildModelListener thinClientBuildModelListener = this;
        Project project = session2.getProject();
        Lifetime lifetime2 = lifetime;
        ThinClientBuildModel thinClientBuildModel = model;
        IAsyncSignal signal$iv = model.getBuildEvent();
        boolean $i$f$syncFromModel = false;
        signal$iv.advise(lifetime$iv, (Function1)new Function1<BuildEventModel, Unit>(project$iv, model$iv){
            final /* synthetic */ Project $project;
            final /* synthetic */ ThinClientBuildModel $model;
            {
                this.$project = $project;
                this.$model = $model;
            }

            public final void invoke(BuildEventModel event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<BuildViewManager> serviceClass$iv = BuildViewManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((AbstractViewManager)object).onEvent((Object)event.getBuildId(), BuildModelUtilsKt.fromProtocolModel(event, this.$project, this.$model));
            }
        });
        ThinClientBuildModelListener this_$iv = this;
        project$iv = session2.getProject();
        lifetime$iv = lifetime;
        model$iv = model;
        signal$iv = model.getSyncEvent();
        $i$f$syncFromModel = false;
        signal$iv.advise(lifetime$iv, (Function1)new Function1<BuildEventModel, Unit>(project$iv, model$iv){
            final /* synthetic */ Project $project;
            final /* synthetic */ ThinClientBuildModel $model;
            {
                this.$project = $project;
                this.$model = $model;
            }

            public final void invoke(BuildEventModel event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<SyncViewManager> serviceClass$iv = SyncViewManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((AbstractViewManager)object).onEvent((Object)event.getBuildId(), BuildModelUtilsKt.fromProtocolModel(event, this.$project, this.$model));
            }
        });
    }

    private final /* synthetic */ <T extends AbstractViewManager> void syncFromModel(Project project, Lifetime lifetime, ThinClientBuildModel model, IAsyncSignal<BuildEventModel> signal) {
        boolean $i$f$syncFromModel = false;
        Intrinsics.needClassReification();
        signal.advise(lifetime, (Function1)new Function1<BuildEventModel, Unit>(project, model){
            final /* synthetic */ Project $project;
            final /* synthetic */ ThinClientBuildModel $model;
            {
                this.$project = $project;
                this.$model = $model;
            }

            public final void invoke(BuildEventModel event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                Class<Object> serviceClass$iv = Object.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((AbstractViewManager)object).onEvent((Object)event.getBuildId(), BuildModelUtilsKt.fromProtocolModel(event, this.$project, this.$model));
            }
        });
    }

    private final void releaseEventEditors(Lifetime lifetime, IAsyncSignal<BuildEventModel> signal) {
        signal.advise(lifetime, arg_0 -> ThinClientBuildModelListener.releaseEventEditors$lambda$1(lifetime, arg_0));
    }

    private static final Unit releaseEventEditors$lambda$1$lambda$0(Editor $editor) {
        if (!$editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor($editor);
        }
        return Unit.INSTANCE;
    }

    private static final Unit releaseEventEditors$lambda$1(Lifetime $lifetime, BuildEventModel event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.error("Unexpected build event from Host, build events should not be sent to Controller: " + event);
        if (!(event instanceof StartBuildEventModel)) {
            return Unit.INSTANCE;
        }
        TextControlId textControlId = ((StartBuildEventModel)event).getConsoleTextControlId();
        if (textControlId == null) {
            return Unit.INSTANCE;
        }
        TextControlId editorId = textControlId;
        Editor editor = FrontendTextControlHostKt.toEditorOrNull((TextControlId)editorId);
        if (editor == null) {
            return Unit.INSTANCE;
        }
        Editor editor2 = editor;
        $lifetime.onTermination(() -> ThinClientBuildModelListener.releaseEventEditors$lambda$1$lambda$0(editor2));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientBuildModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientBuildModelListener.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/execution/frontend/split/ThinClientBuildModelListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

