/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyCallChunkBlockBuilder {
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final FormattingMode myFormattingMode;

    public LegacyCallChunkBlockBuilder(@NotNull CommonCodeStyleSettings settings, @NotNull JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (settings == null) {
            LegacyCallChunkBlockBuilder.$$$reportNull$$$0(0);
        }
        if (javaSettings == null) {
            LegacyCallChunkBlockBuilder.$$$reportNull$$$0(1);
        }
        if (formattingMode == null) {
            LegacyCallChunkBlockBuilder.$$$reportNull$$$0(2);
        }
        this.mySettings = settings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myJavaSettings = javaSettings;
        this.myFormattingMode = formattingMode;
    }

    @NotNull
    public Block create(@NotNull List<? extends ASTNode> subNodes, Wrap wrap, @Nullable Alignment alignment) {
        if (subNodes == null) {
            LegacyCallChunkBlockBuilder.$$$reportNull$$$0(3);
        }
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        ASTNode firstNode = subNodes.get(0);
        if (firstNode.getElementType() == JavaTokenType.DOT) {
            AlignmentStrategy strategy = AlignmentStrategy.getNullStrategy();
            Block block = AbstractJavaBlock.newJavaBlock(firstNode, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null, strategy, this.myFormattingMode);
            subBlocks.add(block);
            subNodes.remove(0);
            if (!subNodes.isEmpty()) {
                subBlocks.add(this.create(subNodes, wrap, null));
            }
            return new SyntheticCodeBlock(subBlocks, alignment, this.mySettings, this.myJavaSettings, Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS), wrap);
        }
        return new SyntheticCodeBlock(this.createJavaBlocks(subNodes), alignment, this.mySettings, this.myJavaSettings, Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS), null);
    }

    @NotNull
    private List<Block> createJavaBlocks(@NotNull List<? extends ASTNode> subNodes) {
        if (subNodes == null) {
            LegacyCallChunkBlockBuilder.$$$reportNull$$$0(4);
        }
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode aSTNode : subNodes) {
            Indent indent = Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
            result.add(AbstractJavaBlock.newJavaBlock(aSTNode, this.mySettings, this.myJavaSettings, indent, null, AlignmentStrategy.getNullStrategy(), this.myFormattingMode));
        }
        ArrayList<Block> arrayList = result;
        if (arrayList == null) {
            LegacyCallChunkBlockBuilder.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subNodes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/LegacyCallChunkBlockBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/LegacyCallChunkBlockBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createJavaBlocks";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

