/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cachewrappers;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class EHCacheReplicationTest {
    @BeforeMethod
    public void setUp() {
        System.setProperty("bind.address", "127.0.0.1");
    }

    public void testSyncReplication() throws Exception {
        CacheManager c1 = new CacheManager("C:\\jboss\\benchmarks\\CacheBenchmarkFwk\\cache-products\\ehcache-1.5.0\\conf\\ehcache-repl-sync.xml");
        CacheManager c2 = new CacheManager("C:\\jboss\\benchmarks\\CacheBenchmarkFwk\\cache-products\\ehcache-1.5.0\\conf\\ehcache-repl-sync.xml");
        Cache cache1 = c1.getCache("cache");
        Cache cache2 = c2.getCache("cache");
        Thread.sleep(5000L);
        System.out.println("c1 members: " + c1.getCachePeerListener("RMI").getBoundCachePeers());
        System.out.println("c2 members" + c2.getCachePeerListener("RMI").getBoundCachePeers());
        assert (c1.getCachePeerListener("RMI").getBoundCachePeers().size() == 1);
        assert (c2.getCachePeerListener("RMI").getBoundCachePeers().size() == 1);
        for (int i = 0; i < 100; ++i) {
            cache1.put(new Element((Serializable)((Object)("key" + i)), (Serializable)((Object)("value" + i))));
            assert (cache2.get((Serializable)((Object)("key" + i))).getValue().equals("value" + i));
        }
        System.out.println(cache1.getKeys());
        System.out.println(cache2.getKeys());
        c1.shutdown();
        c2.shutdown();
    }

    public void testInvalidation() throws Exception {
        CacheManager c1 = new CacheManager("C:\\jboss\\benchmarks\\CacheBenchmarkFwk\\cache-products\\ehcache-1.5.0\\conf\\ehcache-invalidate-sync.xml");
        CacheManager c2 = new CacheManager("C:\\jboss\\benchmarks\\CacheBenchmarkFwk\\cache-products\\ehcache-1.5.0\\conf\\ehcache-invalidate-sync.xml");
        Cache cache1 = c1.getCache("cache");
        Cache cache2 = c2.getCache("cache");
        Thread.sleep(5000L);
        System.out.println("c1 members: " + c1.getCachePeerListener("RMI").getBoundCachePeers());
        System.out.println("c2 members" + c2.getCachePeerListener("RMI").getBoundCachePeers());
        assert (c1.getCachePeerListener("RMI").getBoundCachePeers().size() == 1);
        assert (c2.getCachePeerListener("RMI").getBoundCachePeers().size() == 1);
        cache1.put(new Element((Serializable)((Object)"key"), (Serializable)((Object)"value")));
        assert (cache2.get((Serializable)((Object)"key")).getValue().equals("value"));
        cache2.put(new Element((Serializable)((Object)"key"), (Serializable)((Object)"newValue")));
        assert (cache1.get((Serializable)((Object)"key")) == null);
        c1.shutdown();
        c2.shutdown();
    }
}

