/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cachewrappers;

import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHCacheWrapper
implements CacheWrapper {
    private CacheManager manager;
    private Ehcache cache;
    private Log log = LogFactory.getLog((String)"org.cachebench.cachewrappers.EHCacheWrapper");
    boolean localmode;

    @Override
    public void init(Map parameters) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Entering EHCacheWrapper.init()");
        }
        this.localmode = Boolean.parseBoolean((String)parameters.get("localOnly"));
        this.log.debug((Object)("Initializing the cache with props " + parameters));
        URL url = this.getClass().getClassLoader().getResource((String)parameters.get("config"));
        this.log.debug((Object)("Config URL = " + url));
        Configuration c = ConfigurationFactory.parseConfiguration((URL)url);
        c.setSource("URL of " + url);
        this.manager = new CacheManager(c);
        this.setUp();
        this.log.debug((Object)"Finish Initializing the cache");
    }

    @Override
    public void setUp() throws Exception {
        this.log.info((Object)"Caches avbl:");
        for (String s : this.manager.getCacheNames()) {
            this.log.info((Object)("    * " + s));
        }
        this.cache = this.manager.getCache("cache");
        this.log.info((Object)("Using named cache " + this.cache));
        if (!this.localmode) {
            this.log.info((Object)("Bounded peers: " + this.manager.getCachePeerListener("RMI").getBoundCachePeers()));
            this.log.info((Object)("Remote peers: " + this.manager.getCacheManagerPeerProvider("RMI").listRemoteCachePeers(this.cache)));
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.manager.shutdown();
    }

    public void putSerializable(Serializable key, Serializable value) throws Exception {
        Element element = new Element(key, value);
        this.cache.put(element);
    }

    public Object getSerializable(Serializable key) throws Exception {
        return this.cache.get(key);
    }

    @Override
    public void empty() throws Exception {
        this.cache.removeAll();
    }

    @Override
    public void put(List<String> path, Object key, Object value) throws Exception {
        this.putSerializable((Serializable)key, (Serializable)value);
    }

    @Override
    public Object get(List<String> path, Object key) throws Exception {
        Object s = this.getSerializable((Serializable)key);
        if (s instanceof Element) {
            return ((Element)s).getValue();
        }
        return s;
    }

    @Override
    public int getNumMembers() {
        return this.localmode ? 0 : this.manager.getCacheManagerPeerProvider("RMI").listRemoteCachePeers(this.cache).size();
    }

    @Override
    public String getInfo() {
        return this.cache.getKeys().toString() + (this.localmode ? "" : " remote peers: " + this.manager.getCachePeerListener("RMI").getBoundCachePeers());
    }

    @Override
    public Object getReplicatedData(List<String> path, String key) throws Exception {
        Object o = this.get(path, key);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Result for the key: '" + key + "' is value '" + o + "'"));
        }
        return o;
    }

    @Override
    public Object startTransaction() {
        throw new UnsupportedOperationException("Does not support JTA!");
    }

    @Override
    public void endTransaction(boolean successful) {
        throw new UnsupportedOperationException("Does not support JTA!");
    }
}

