/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.config;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.config.NodeAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterConfig {
    public static final Log log = LogFactory.getLog(ClusterConfig.class);
    private int currentNodeIndex = -1;
    private int clusterSize = -1;
    private List<NodeAddress> members = new ArrayList<NodeAddress>();
    private String bindAddress;

    public int getCurrentNodeIndex() {
        if (this.currentNodeIndex == -1) {
            String serverindexStr = System.getProperty("currentIndex");
            try {
                this.currentNodeIndex = Integer.parseInt(serverindexStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Configuration 'currentIndex' is missing!");
            }
        }
        return this.currentNodeIndex;
    }

    public List<NodeAddress> getMembers() {
        if (this.members.size() > this.getClusterSize()) {
            return this.members.subList(0, this.clusterSize);
        }
        return this.members;
    }

    public int getPortForThisNode() {
        NodeAddress address = this.getMembers().get(this.getCurrentNodeIndex());
        return Integer.parseInt(address.getPort());
    }

    public NodeAddress getAddressForThisNode() {
        return this.getMembers().get(this.getCurrentNodeIndex());
    }

    public int getClusterSize() {
        if (this.clusterSize < 0) {
            String clusterSizeStr = System.getProperty("clusterSize");
            if (clusterSizeStr != null) {
                int size = Integer.parseInt(clusterSizeStr);
                log.info((Object)("Received cluster size: " + size));
                this.clusterSize = size;
            } else {
                return this.members.size();
            }
        }
        return this.clusterSize;
    }

    public boolean isMaster() {
        return this.getCurrentNodeIndex() == 0;
    }

    public void addMember(NodeAddress member) {
        this.members.add(member);
    }

    public String getBindAddress() {
        if (this.bindAddress == null) {
            this.bindAddress = System.getProperties().getProperty("bind.address");
        }
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public List<InetSocketAddress> getMemberAddresses() {
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>();
        for (NodeAddress address : this.getMembers()) {
            result.add(new InetSocketAddress(address.getHost(), address.getPortAsInt()));
        }
        return result;
    }

    public String toString() {
        return "{bindAddress:" + this.bindAddress + ", members:" + this.getMembers() + ", clusterSize:" + this.getClusterSize() + "}";
    }

    public void validateMembers() {
        List<InetSocketAddress> addressList = this.getMemberAddresses();
        HashSet<InetSocketAddress> addressSet = new HashSet<InetSocketAddress>(addressList);
        if (addressList.size() != addressSet.size()) {
            throw new RuntimeException("There are memebers defined which point to the same host:port. Verify the configuration");
        }
    }
}

