/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators.reportcentralizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cachebench.reportgenerators.reportcentralizer.ReportData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationData {
    private String configurationName;
    private Set<String> distributions = new HashSet<String>();
    private Map<String, List<ReportData>> distriution2ReportDataMap = new HashMap<String, List<ReportData>>();

    public ConfigurationData(String configurationName) {
        this.configurationName = configurationName;
    }

    public void addIfNeeded(ReportData reportData) {
        if (reportData.getConfiguration().equals(this.configurationName)) {
            String distribution = reportData.getDistribution();
            this.distributions.add(distribution);
            List<ReportData> dataList = this.distriution2ReportDataMap.get(distribution);
            if (dataList == null) {
                dataList = new ArrayList<ReportData>();
                this.distriution2ReportDataMap.put(distribution, dataList);
            }
            dataList.add(reportData);
        }
    }

    public Map<String, List<ReportData>> getDistriution2ReportDataMap() {
        for (List<ReportData> datas : this.distriution2ReportDataMap.values()) {
            Collections.sort(datas);
        }
        return this.distriution2ReportDataMap;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public int[] getClusterSizes() {
        String aDistribution = this.distributions.iterator().next();
        List<ReportData> reportDatas = this.getDistriution2ReportDataMap().get(aDistribution);
        int[] result = new int[reportDatas.size()];
        for (int i = 0; i < reportDatas.size(); ++i) {
            result[i] = reportDatas.get(i).getClusterSize();
        }
        return result;
    }
}

