<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

April 20, 2020

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [ ] Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Carol Payne - Netflix
  * [X] Mei Chu - Sony Pictures Imageworks
  * [X] Shakeel Muhammad

# **OCIO TSC Meeting Notes**

* PRs for review
    - Michael: There are two Autodesk PRs waiting for review.
    - Doug: One is related to op finalization (#986). We looked at how ops 
      are finalized prior to evaluation, including optimization steps, 
      converting inverse LUTs into forward LUTs, etc. There was some 
      unnecessary cloning of ops.
    - Patrick: We discovered cloning and slow downs in optimization and 
      finalization and fixed them. Lots of changes, but only fixes. Some ops 
      can have a processing cost at finalization, and we tried to avoid that. 
      There are no high level changes; only internal processing improvements.
    - Doug: For example, if you need a CPU and GPU processor, this reduces the 
      necessary work  to support that.
    - Patrick: Very important for integrating OCIO into DCCs, to limit 
      performance impact.
    - Doug: The PR feels big since it impacts all ops, but the changes are 
      similar for each.
    - Doug: The other PR refactors GPU usage in apps (#985). We wanted to allow 
      CPU and GPU evaluation in apps and utilities without copying/pasting a 
      lot of code, so this PR improves reuse between tools.
    - Patrick: It also improves commandline tools to offer good usage examples 
      for the library, which is important for DCC integration. It's part of 
      ongoing improvements in this area.
    - Bernard: It helps avoid copying and pasting code.
    - Michael: PR #991 is ready with GH Actions support. GH Actions is fairly 
      similar to AZP, but doesn't have all the same capability. It doesn't offer
      template capability yet for example. GH Actions does work in OCIO forks 
      though, which expands usage quite a bit. To use in your fork, you'll have 
      to temporarily add your feature branch to the included push branch list.
    - Michael: PR #890, which adds our missions statement to README.md is out of 
      draft now and ready for further review.

* Documentation updates
    - Sean: I've looked at static site generators, but don't think they serve our 
      needs well. I recommend continuing forward with Sphinx. It's widely used and 
      works well.
    - I noticed there are no docstrings in the Python bindings yet. An interesting 
      solution to consider is what was done for Matsuba, another project from the 
      pybind11 author. It rips docstrings from cpp headers and injects them in the 
      bindings, so documentation exists in only one place. It's a good source of 
      inspiration, but could be good to have dosctrings in bindings still, for 
      dicoverability.
    - Our doc needs are varried; there's the website, docstring extraction, etc. 
      Nothing out of the box works with multiple languages. Overall, our docs don't 
      fit anymore, and need work. I will work with Carol on a plan, and to come up 
      with user stories.
    - Much later down the road, it would be nice to collate collective studio 
      experience for reference. It's nice to see what studios are doing, and what 
      systems they have built around it. Case studies would be great, including from 
      other industries like Netflix.
    - Carol: I agree, and will work with Sean on this.
    - Sean: I will make GH issues to break down tasks further.
    
* String locale handling
    - Doug: PR #984 is about fixing string case handling for Turkish locale. This 
      raises bigger case sensitivty issues. File extensions should be case 
      insensitive for example.
    - The proposal is to convert case as if it were english case, so that locale wouldnt 
      matter. Two questions we need to answer. Do we want case sensitivety to depend on 
      locale? Secondly, what areas of the library should use case-insensitive comparison?
    - We do case insensitive compares in places that might be unncessary. Color space 
      names, role names, etc. Anywhere Lower() function is used.
    - Mark: Roles should be case insensitive. Traditionally color space names too. File 
      names should be dependent on filesystem and OS behavior. it's a tough question 
      though. Unicode can complicate matters.
    - Doug: Do people use non-english chars in configs?
    - Mark: Not in my experience, but they could.
    - Doug: The bug the PR is fixing is related to the .spi1d extension, due to the 
      Turkish local using "I" instead of "i".
    - Patrick: There are no round trip ways to do this. Extensions are only US letters, and 
      we know what extensions we support.
    - Mark: Filenames should never need a conversion. We dont want to abstract away from 
      filesystem behavior. Use whatever it supports. Only FileTransform and CDLTransform take 
      file names, and shouldn't depend on text lookup.
    - Doug: When looking for color space name in filepath, it gets complicated.
    - Mark. Can we remove the extension from a filename before a color space check? Unless 
      there's a file extension specific color space name.
    - Doug: The PR is proposing comparisons ignore locale, and instead have 
      them behave as if always english. Not a bad thing to remove locale, as it removes a 
      variable of complexity, but it needs discussion to agree on a solution.
    - Michael: Let's continue that dsicssuion offline in the PR for now, since there is a 
      good conversation happening there.
    - Doug: We are happy to discuss it further later if anyone wants as well.
