/*  color.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef REDUZE_COLOR_H_
#define REDUZE_COLOR_H_

#ifndef OVERRIDE
#ifdef NEW_GINAC
#define OVERRIDE override
#else
#define OVERRIDE
#endif
#endif

#include <ginac/ginac.h>

namespace Reduze {

/// an index class for color indices in the adjoined representation with
/// the symbolic dimension Da (= N^2-1) which knows also the dimension Df = N
class idx2: public GiNaC::idx {
GINAC_DECLARE_REGISTERED_CLASS(idx2, GiNaC::idx)
public:
	explicit idx2(const GiNaC::ex& v, const GiNaC::ex& dim1,
			const GiNaC::ex& dim2);
	GiNaC::ex get_dim2() const;

	// functions overriding virtual functions from base classes
public:
	GiNaC::ex subs(const GiNaC::exmap& m, unsigned options = 0) const OVERRIDE;
	void archive(GiNaC::archive_node& n) const OVERRIDE;
	void read_archive(const GiNaC::archive_node& n, GiNaC::lst& sym_lst) OVERRIDE;
	bool is_dummy_pair_same_type(const GiNaC::basic& other) const OVERRIDE;

protected:
	bool match_same_type(const GiNaC::basic& other) const OVERRIDE;
	void do_print(const GiNaC::print_context& c, unsigned level) const;

	// internal constructor
	explicit idx2(const GiNaC::idx& i, const GiNaC::ex& dim2);
protected:
	GiNaC::ex dim2_;
};

GINAC_DECLARE_UNARCHIVER(idx2)
;

inline GiNaC::ex idx2::get_dim2() const {
	return dim2_;
}

/// the f^abc tensor
class sunf_tensor: public GiNaC::tensor {
GINAC_DECLARE_REGISTERED_CLASS(sunf_tensor, GiNaC::tensor)
public:
	GiNaC::ex eval_indexed(const GiNaC::basic& i) const OVERRIDE;
	bool contract_with(GiNaC::exvector::iterator self,
			GiNaC::exvector::iterator other, GiNaC::exvector& v) const OVERRIDE;
protected:
	unsigned return_type() const OVERRIDE {
		return GiNaC::return_types::commutative;
	}
	void do_print(const GiNaC::print_context& c, unsigned level) const;
};
GINAC_DECLARE_UNARCHIVER(sunf_tensor)
;

//
//
//

/// the T^a_ij tensor
class sunt_tensor: public GiNaC::tensor {
GINAC_DECLARE_REGISTERED_CLASS(sunt_tensor, GiNaC::tensor)
public:
	GiNaC::ex eval_indexed(const GiNaC::basic& i) const OVERRIDE;
	bool contract_with(GiNaC::exvector::iterator self,
			GiNaC::exvector::iterator other, GiNaC::exvector& v) const OVERRIDE;
	GiNaC::ex conjugate() const OVERRIDE;
protected:
	unsigned return_type() const OVERRIDE {
		return GiNaC::return_types::commutative;
	}
	void do_print(const GiNaC::print_context& c, unsigned level) const;
};
GINAC_DECLARE_UNARCHIVER(sunt_tensor)
;

//
//
//

/// the complex conjugated of T^a_ij
class suntc_tensor: public GiNaC::tensor {
GINAC_DECLARE_REGISTERED_CLASS(suntc_tensor, GiNaC::tensor)
public:
	GiNaC::ex eval_indexed(const GiNaC::basic& i) const OVERRIDE;
	bool contract_with(GiNaC::exvector::iterator self,
			GiNaC::exvector::iterator other, GiNaC::exvector& v) const OVERRIDE;
	GiNaC::ex conjugate() const OVERRIDE;
protected:
	unsigned return_type() const OVERRIDE {
		return GiNaC::return_types::commutative;
	}
	void do_print(const GiNaC::print_context& c, unsigned level) const;
};
GINAC_DECLARE_UNARCHIVER(suntc_tensor)
;

//
// wrapper functions to create the tensors with symbols as arguments
//


/// create a indexed T^a_ij tensor
GiNaC::ex sunt(const GiNaC::ex& a, const GiNaC::ex& i1, const GiNaC::ex& i2);
/// create a indexed f_abc tensor
GiNaC::ex sunf(const GiNaC::ex& a1, const GiNaC::ex& a2, const GiNaC::ex& a3);
/// create sunf tensor f_abx * f_cdx
GiNaC::ex sunf(const GiNaC::ex& a1, const GiNaC::ex& a2, const GiNaC::ex& a3,
		const GiNaC::ex& a4);

} // namespace Reduze


#endif /* REDUZE_COLOR_H_ */
