---
title: Abyssinica SIL - Character Set Support
fontversion: 2.201
---

This font contains complete coverage of all the characters defined in Unicode for Ethiopic. The Ethiopic script is used for writing many of the languages of Ethiopia and Eritrea. [Ethiopic (U+1200..U+137F)](https://www.unicode.org/charts/PDF/U1200.pdf) was added to Unicode 3.0. [Ethiopic Supplement (U+1380..U+139F)](https://www.unicode.org/charts/PDF/U1380.pdf) and [Ethiopic Extended (U+2D80..U+2DDF)](https://www.unicode.org/charts/PDF/U2D80.pdf) were added to Unicode 4.1. [Ethiopic Extended-A (U+AB00..U+AB2F)](https://www.unicode.org/charts/PDF/UAB00.pdf) was added to Unicode 6.0. [Ethiopic Extended-B U+1E7E0..U+1E7FF)](https://www.unicode.org/charts/PDF/U1E7E0.pdf)  was added to Unicode 14.0. *Abyssinica SIL* supports all Ethiopic characters which are in Unicode. As far as we are aware, all languages using the Ethiopic script are now fully represented in Unicode. 


## Supported characters

The following character ranges are supported by this font:

Unicode block | Abyssinica SIL support
------------- | ---------------
C0 Controls and Basic Latin|U+0020..U+007E
C1 Controls and Latin-1 Supplement|U+00A0..U+00FF
Latin Extended-A|U+0131, U+0152..U+0153, U+0160..U+0161, U+0178, U+017D..U+017E
Latin Extended-B|U+0192
Spacing Modifier Letters|U+02C6, U+02C7, U+02D0, U+02D8..U+02DD
Combining Diacritical Marks|U+0300..U+0304, U+0307..U+0308, U+030B..U+030C, U+030F, U+034F
Greek|U+03C0
Ethiopic|U+1200..137C
Ethiopic Supplemental|U+1380..U+1399
Ethiopic Extended|U+2D80..U+2DDE
General Punctuation|U+2000..U+2015, U+2018..U+201A, U+201C..U+201E, U+2020..U+2022, U+2026..U+2030, U+2039..U+203B, U+2044, U+2060
Superscripts and Subscripts|U+2070, U+2074..U+2079
Currency Symbols|U+20AC
Letterlike Symbols|U+2122, U+2126
Mathematical Operators|U+2202, U+2205..U+2206, U+220F, U+2211, U+2219..U+221A, U+221E, U+222B, U+2248, U+2260, U+2264..U+2265
Control Pictures|U+2423
Geometric Shapes|U+25CA, U+25CC
Dingbats|U+2713
Ethiopic Extended-A|U+AB00..U+AB2E
PUA|U+E494, U+E496
Alphabetic Presentation Forms|U+FB01..U+FB02
Ethiopic Extended-B|U+1E7E0..U+1E7FF


## Private-use (PUA) characters

Because the majority of the PUA characters have now been encoded into Unicode, or they were considered glyph variants, all PUA characters in the font have been removed with the exception of U+E494 (<span class='abyssinica-R normal'></span>) and U+E496 (<span class='abyssinica-R normal'></span>). Some of the PUA codepoints were actually glyph variants of characters already encoded in Unicode. These are now available through OpenType Character Variants, Graphite features, or TypeTuned fonts. See [Font Features](features.md).

PUA characters that were previously in the font are documented here:

[SIL Ethiopic Private Use Area Block](https://software.sil.org/abyssinica/wp-content/uploads/sites/26/2016/02/AbyssinicaSIL_PUA.pdf)

<!-- PRODUCT SITE ONLY
[font id='abyssinica' face='AbyssinicaSIL-Regular' size='150%']
-->
