/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Panel;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.ConditionHistory;
import com.izforge.izpack.installer.ConditionHistoryTableCellRenderer;
import com.izforge.izpack.installer.ConditionHistoryTableModel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.VariableHistory;
import com.izforge.izpack.installer.VariableHistoryTableCellRenderer;
import com.izforge.izpack.installer.VariableHistoryTableModel;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class Debugger {
    private RulesEngine rules;
    private InstallData idata;
    private Properties lasttimevariables;
    private JTextPane debugtxt;
    private IconsDatabase icons;
    private Map<String, VariableHistory> variableshistory;
    private Map<String, ConditionHistory> conditionhistory;
    private JTable variablestable;
    private VariableHistoryTableModel variablesmodel;
    private VariableHistoryTableCellRenderer variablesrenderer;
    private ConditionHistoryTableModel conditionhistorymodel;
    private ConditionHistoryTableCellRenderer conditionhistoryrenderer;

    public Debugger(InstallData installData, IconsDatabase iconsDatabase, RulesEngine rulesEngine) {
        this.idata = installData;
        this.rules = rulesEngine;
        this.lasttimevariables = (Properties)this.idata.variables.clone();
        this.icons = iconsDatabase;
        this.variableshistory = new HashMap<String, VariableHistory>();
        this.conditionhistory = new HashMap<String, ConditionHistory>();
        this.init();
    }

    private void init() {
        String[] stringArray;
        String[] stringArray2 = stringArray = this.lasttimevariables.keySet().toArray(new String[this.lasttimevariables.size()]);
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            VariableHistory object = new VariableHistory(string);
            object.addValue(this.lasttimevariables.getProperty(string), "initial value");
            this.variableshistory.put(string, object);
        }
        for (String string : stringArray2 = this.rules.getKnownConditionIds()) {
            Condition condition = RulesEngine.getCondition(string);
            boolean bl = this.rules.isConditionTrue(condition);
            ConditionHistory conditionHistory = null;
            conditionHistory = new ConditionHistory(condition);
            conditionHistory.addValue(bl, "initial value");
            this.conditionhistory.put(string, conditionHistory);
        }
    }

    private void debugVariables(Panel panel, Panel panel2) {
        this.getChangedVariables(panel, panel2);
        this.lasttimevariables = (Properties)this.idata.variables.clone();
    }

    private void debugConditions(Panel panel, Panel panel2) {
        this.conditionhistoryrenderer.clearState();
        this.updateChangedConditions("changed after panel switch from " + panel2.getPanelid() + " to " + panel.getPanelid());
    }

    private void updateChangedConditions(String string) {
        String[] stringArray;
        for (String string2 : stringArray = this.rules.getKnownConditionIds()) {
            Condition condition = RulesEngine.getCondition(string2);
            ConditionHistory conditionHistory = null;
            if (!this.conditionhistory.containsKey(string2)) {
                conditionHistory = new ConditionHistory(condition);
                this.conditionhistory.put(string2, conditionHistory);
            } else {
                conditionHistory = this.conditionhistory.get(string2);
            }
            conditionHistory.addValue(this.rules.isConditionTrue(condition), string);
        }
        this.conditionhistorymodel.fireTableDataChanged();
    }

    private Properties getChangedVariables(Panel panel, Panel panel2) {
        Properties properties = (Properties)this.idata.variables.clone();
        Properties properties2 = new Properties();
        this.variablesrenderer.clearState();
        Enumeration<Object> enumeration = properties.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            VariableHistory variableHistory;
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            String string3 = this.lasttimevariables.getProperty(string);
            if (string3 == null) {
                variableHistory = new VariableHistory(string);
                variableHistory.addValue(string2, "new after panel " + panel2.getPanelid());
                this.variableshistory.put(string, variableHistory);
                bl = true;
                properties2.put(string, string2);
                continue;
            }
            if (string2.equals(string3)) continue;
            variableHistory = this.variableshistory.get(string);
            variableHistory.addValue(string2, "changed value after panel " + panel2.getPanelid());
            bl = true;
            properties2.put(string, string2);
        }
        if (bl) {
            this.variablesmodel.fireTableDataChanged();
        }
        return properties2;
    }

    private void modifyVariableManually(String string, String string2) {
        this.lasttimevariables = (Properties)this.idata.variables.clone();
        VariableHistory variableHistory = this.variableshistory.get(string);
        if (variableHistory != null) {
            variableHistory.addValue(string2, "modified manually");
        }
        this.variablesmodel.fireTableDataChanged();
        this.updateChangedConditions("after manual modification of variable " + string);
    }

    public JPanel getDebugPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        jPanel.setLayout(new BorderLayout());
        this.variablesmodel = new VariableHistoryTableModel(this.variableshistory);
        this.variablesrenderer = new VariableHistoryTableCellRenderer(this.variableshistory);
        this.variablestable = new JTable(this.variablesmodel);
        this.variablestable.setDefaultRenderer(VariableHistory.class, this.variablesrenderer);
        this.variablestable.setSelectionMode(0);
        this.variablestable.setRowSelectionAllowed(true);
        JScrollPane jScrollPane = new JScrollPane(this.variablestable);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        final JTextField jTextField = new JTextField();
        jPanel2.add(jTextField);
        JLabel jLabel = new JLabel("=");
        jPanel2.add(jLabel);
        final JTextField jTextField2 = new JTextField();
        jPanel2.add(jTextField2);
        JButton jButton = ButtonFactory.createButton(this.idata.langpack.getString("debug.changevariable"), this.icons.getImageIcon("debug.changevariable"), this.idata.buttonsHColor);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                String string2 = jTextField2.getText();
                if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                    Debugger.this.idata.setVariable(string, string2);
                    Debugger.this.modifyVariableManually(string, string2);
                }
            }
        });
        this.variablestable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = Debugger.this.variablestable.getSelectedRow();
                String string = (String)Debugger.this.variablesmodel.getValueAt(n, 0);
                if (mouseEvent.getClickCount() == 1) {
                    jTextField.setText(string);
                } else {
                    VariableHistory variableHistory = (VariableHistory)Debugger.this.variableshistory.get(string);
                    JFrame jFrame = new JFrame("Details");
                    JTextPane jTextPane = new JTextPane();
                    jTextPane.setContentType("text/html");
                    jTextPane.setText(variableHistory.getValueHistoryDetails());
                    jTextPane.setEditable(false);
                    JScrollPane jScrollPane = new JScrollPane(jTextPane);
                    Container container = jFrame.getContentPane();
                    container.setLayout(new BorderLayout());
                    container.add((Component)jScrollPane, "Center");
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.conditionhistorymodel = new ConditionHistoryTableModel(this.conditionhistory);
        final JTable jTable = new JTable(this.conditionhistorymodel);
        this.conditionhistoryrenderer = new ConditionHistoryTableCellRenderer(this.conditionhistory);
        jTable.setDefaultRenderer(ConditionHistory.class, this.conditionhistoryrenderer);
        jTable.setSelectionMode(0);
        jTable.setRowSelectionAllowed(true);
        jTable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = jTable.getSelectedRow();
                String string = (String)jTable.getModel().getValueAt(n, 0);
                if (mouseEvent.getClickCount() == 2) {
                    ConditionHistory conditionHistory = (ConditionHistory)Debugger.this.conditionhistory.get(string);
                    JFrame jFrame = new JFrame("Details");
                    JTextPane jTextPane = new JTextPane();
                    jTextPane.setContentType("text/html");
                    jTextPane.setText(conditionHistory.getConditionHistoryDetails());
                    jTextPane.setEditable(false);
                    JScrollPane jScrollPane = new JScrollPane(jTextPane);
                    Container container = jFrame.getContentPane();
                    container.setLayout(new BorderLayout());
                    container.add((Component)jScrollPane, "Center");
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(jTable);
        jPanel3.add((Component)jScrollPane2, "Center");
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.insertTab("Variable settings", null, jPanel, "", 0);
        jTabbedPane.insertTab("Condition settings", null, jPanel3, "", 1);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jTabbedPane, "Center");
        return jPanel4;
    }

    public void switchPanel(Panel panel, Panel panel2) {
        this.debugVariables(panel, panel2);
        this.debugConditions(panel, panel2);
    }

    public void packSelectionChanged(String string) {
        this.updateChangedConditions(string);
    }
}

