/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'lookup_fast' function
 *
 * Notes:
 *  - Enforce Exploit Detection pCFI
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 20.II.2019
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_PCFI_LOOKUP_FAST_H
#define P_LKRG_EXPLOIT_DETECTION_PCFI_LOOKUP_FAST_H

/* per-instance private data */
struct p_pcfi_lookup_fast_data {
    ktime_t entry_stamp;
};


int p_pcfi_lookup_fast_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_pcfi_lookup_fast_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_pcfi_lookup_fast_hook(int p_isra);
void p_uninstall_pcfi_lookup_fast_hook(void);

#endif
