// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test2.proto

#ifndef GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_GOLDEN_REST_ONLY_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_GOLDEN_REST_ONLY_REST_CONNECTION_IMPL_H

#include "generator/integration_tests/golden/v1/golden_rest_only_connection.h"
#include "generator/integration_tests/golden/v1/golden_rest_only_connection_idempotency_policy.h"
#include "generator/integration_tests/golden/v1/golden_rest_only_options.h"
#include "generator/integration_tests/golden/v1/internal/golden_rest_only_rest_stub.h"
#include "generator/integration_tests/golden/v1/internal/golden_rest_only_retry_traits.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GoldenRestOnlyRestConnectionImpl
    : public golden_v1::GoldenRestOnlyConnection {
 public:
  ~GoldenRestOnlyRestConnectionImpl() override = default;

  GoldenRestOnlyRestConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<golden_v1_internal::GoldenRestOnlyRestStub> stub,
    Options options);

  Options options() override { return options_; }

  Status
  Noop(google::protobuf::Empty const& request) override;

 private:
  static std::unique_ptr<golden_v1::GoldenRestOnlyRetryPolicy>
  retry_policy(Options const& options) {
    return options.get<golden_v1::GoldenRestOnlyRetryPolicyOption>()->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options.get<golden_v1::GoldenRestOnlyBackoffPolicyOption>()->clone();
  }

  static std::unique_ptr<golden_v1::GoldenRestOnlyConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options.get<golden_v1::GoldenRestOnlyConnectionIdempotencyPolicyOption>()->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<golden_v1_internal::GoldenRestOnlyRestStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_GOLDEN_REST_ONLY_REST_CONNECTION_IMPL_H
