// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/vizier_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_VIZIER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_VIZIER_CLIENT_H

#include "google/cloud/aiplatform/v1/vizier_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Vertex AI Vizier API.
///
/// Vertex AI Vizier is a service to solve blackbox optimization problems,
/// such as tuning machine learning hyperparameters and searching over deep
/// learning architectures.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class VizierServiceClient {
 public:
  explicit VizierServiceClient(
      std::shared_ptr<VizierServiceConnection> connection, Options opts = {});
  ~VizierServiceClient();

  ///@{
  /// @name Copy and move support
  VizierServiceClient(VizierServiceClient const&) = default;
  VizierServiceClient& operator=(VizierServiceClient const&) = default;
  VizierServiceClient(VizierServiceClient&&) = default;
  VizierServiceClient& operator=(VizierServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(VizierServiceClient const& a,
                         VizierServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(VizierServiceClient const& a,
                         VizierServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a Study. A resource name will be generated after creation of the
  /// Study.
  ///
  /// @param parent  Required. The resource name of the Location to create the CustomJob in.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param study  Required. The Study configuration used to create the Study.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Study])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateStudyRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L212}
  /// [google.cloud.aiplatform.v1.Study]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Study> CreateStudy(
      std::string const& parent,
      google::cloud::aiplatform::v1::Study const& study, Options opts = {});

  // clang-format off
  ///
  /// Creates a Study. A resource name will be generated after creation of the
  /// Study.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateStudyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Study])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateStudyRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L212}
  /// [google.cloud.aiplatform.v1.Study]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Study> CreateStudy(
      google::cloud::aiplatform::v1::CreateStudyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a Study by name.
  ///
  /// @param name  Required. The name of the Study resource.
  ///  Format: `projects/{project}/locations/{location}/studies/{study}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Study])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetStudyRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L199}
  /// [google.cloud.aiplatform.v1.Study]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Study> GetStudy(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a Study by name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetStudyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Study])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetStudyRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L199}
  /// [google.cloud.aiplatform.v1.Study]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Study> GetStudy(
      google::cloud::aiplatform::v1::GetStudyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all the studies in a region for an associated project.
  ///
  /// @param parent  Required. The resource name of the Location to list the Study from.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Study], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListStudiesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L228}
  /// [google.cloud.aiplatform.v1.Study]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Study> ListStudies(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all the studies in a region for an associated project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListStudiesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Study], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListStudiesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L228}
  /// [google.cloud.aiplatform.v1.Study]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Study> ListStudies(
      google::cloud::aiplatform::v1::ListStudiesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a Study.
  ///
  /// @param name  Required. The name of the Study resource to be deleted.
  ///  Format: `projects/{project}/locations/{location}/studies/{study}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteStudyRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L261}
  ///
  // clang-format on
  Status DeleteStudy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Study.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteStudyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteStudyRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L261}
  ///
  // clang-format on
  Status DeleteStudy(
      google::cloud::aiplatform::v1::DeleteStudyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Looks a study up using the user-defined display_name field instead of the
  /// fully qualified resource name.
  ///
  /// @param parent  Required. The resource name of the Location to get the Study from.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Study])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.LookupStudyRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L274}
  /// [google.cloud.aiplatform.v1.Study]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Study> LookupStudy(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Looks a study up using the user-defined display_name field instead of the
  /// fully qualified resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.LookupStudyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Study])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.LookupStudyRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L274}
  /// [google.cloud.aiplatform.v1.Study]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Study> LookupStudy(
      google::cloud::aiplatform::v1::LookupStudyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Adds one or more Trials to a Study, with parameter values
  /// suggested by Vertex AI Vizier. Returns a long-running
  /// operation associated with the generation of Trial suggestions.
  /// When this long-running operation succeeds, it will contain
  /// a
  /// [SuggestTrialsResponse][google.cloud.aiplatform.v1.SuggestTrialsResponse].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.SuggestTrialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.SuggestTrialsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.SuggestTrialsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L290}
  /// [google.cloud.aiplatform.v1.SuggestTrialsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L351}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::SuggestTrialsResponse>>
  SuggestTrials(
      google::cloud::aiplatform::v1::SuggestTrialsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief SuggestTrials
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> SuggestTrials(
      NoAwaitTag,
      google::cloud::aiplatform::v1::SuggestTrialsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief SuggestTrials
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::SuggestTrialsResponse>>
  SuggestTrials(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Adds a user provided Trial to a Study.
  ///
  /// @param parent  Required. The resource name of the Study to create the Trial in.
  ///  Format: `projects/{project}/locations/{location}/studies/{study}`
  /// @param trial  Required. The Trial to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Trial])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTrialRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L380}
  /// [google.cloud.aiplatform.v1.Trial]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L82}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Trial> CreateTrial(
      std::string const& parent,
      google::cloud::aiplatform::v1::Trial const& trial, Options opts = {});

  // clang-format off
  ///
  /// Adds a user provided Trial to a Study.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateTrialRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Trial])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTrialRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L380}
  /// [google.cloud.aiplatform.v1.Trial]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L82}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Trial> CreateTrial(
      google::cloud::aiplatform::v1::CreateTrialRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a Trial.
  ///
  /// @param name  Required. The name of the Trial resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Trial])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTrialRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L396}
  /// [google.cloud.aiplatform.v1.Trial]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L82}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Trial> GetTrial(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a Trial.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetTrialRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Trial])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTrialRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L396}
  /// [google.cloud.aiplatform.v1.Trial]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L82}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Trial> GetTrial(
      google::cloud::aiplatform::v1::GetTrialRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the Trials associated with a Study.
  ///
  /// @param parent  Required. The resource name of the Study to list the Trial from.
  ///  Format: `projects/{project}/locations/{location}/studies/{study}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Trial], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTrialsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L410}
  /// [google.cloud.aiplatform.v1.Trial]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L82}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Trial> ListTrials(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the Trials associated with a Study.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListTrialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Trial], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTrialsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L410}
  /// [google.cloud.aiplatform.v1.Trial]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L82}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Trial> ListTrials(
      google::cloud::aiplatform::v1::ListTrialsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Adds a measurement of the objective metrics to a Trial. This measurement
  /// is assumed to have been taken before the Trial is complete.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.AddTrialMeasurementRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Trial])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.AddTrialMeasurementRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L443}
  /// [google.cloud.aiplatform.v1.Trial]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L82}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Trial> AddTrialMeasurement(
      google::cloud::aiplatform::v1::AddTrialMeasurementRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Marks a Trial as complete.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CompleteTrialRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Trial])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CompleteTrialRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L460}
  /// [google.cloud.aiplatform.v1.Trial]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L82}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Trial> CompleteTrial(
      google::cloud::aiplatform::v1::CompleteTrialRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a Trial.
  ///
  /// @param name  Required. The Trial's name.
  ///  Format:
  ///  `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteTrialRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L487}
  ///
  // clang-format on
  Status DeleteTrial(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Trial.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteTrialRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteTrialRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L487}
  ///
  // clang-format on
  Status DeleteTrial(
      google::cloud::aiplatform::v1::DeleteTrialRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Checks  whether a Trial should stop or not. Returns a
  /// long-running operation. When the operation is successful,
  /// it will contain a
  /// [CheckTrialEarlyStoppingStateResponse][google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateResponse].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L501}
  /// [google.cloud.aiplatform.v1.CheckTrialEarlyStoppingStateResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L515}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateResponse>>
  CheckTrialEarlyStoppingState(
      google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CheckTrialEarlyStoppingState
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CheckTrialEarlyStoppingState(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CheckTrialEarlyStoppingState
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateResponse>>
  CheckTrialEarlyStoppingState(google::longrunning::Operation const& operation,
                               Options opts = {});

  // clang-format off
  ///
  /// Stops a Trial.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.StopTrialRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Trial])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.StopTrialRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L536}
  /// [google.cloud.aiplatform.v1.Trial]: @googleapis_reference_link{google/cloud/aiplatform/v1/study.proto#L82}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Trial> StopTrial(
      google::cloud::aiplatform::v1::StopTrialRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the pareto-optimal Trials for multi-objective Study or the
  /// optimal Trials for single-objective Study. The definition of
  /// pareto-optimal can be checked in wiki page.
  /// https://en.wikipedia.org/wiki/Pareto_efficiency
  ///
  /// @param parent  Required. The name of the Study that the optimal Trial belongs to.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ListOptimalTrialsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListOptimalTrialsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L550}
  /// [google.cloud.aiplatform.v1.ListOptimalTrialsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L562}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ListOptimalTrialsResponse>
  ListOptimalTrials(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the pareto-optimal Trials for multi-objective Study or the
  /// optimal Trials for single-objective Study. The definition of
  /// pareto-optimal can be checked in wiki page.
  /// https://en.wikipedia.org/wiki/Pareto_efficiency
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListOptimalTrialsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ListOptimalTrialsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListOptimalTrialsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L550}
  /// [google.cloud.aiplatform.v1.ListOptimalTrialsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/vizier_service.proto#L562}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ListOptimalTrialsResponse>
  ListOptimalTrials(
      google::cloud::aiplatform::v1::ListOptimalTrialsRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<VizierServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_VIZIER_CLIENT_H
