// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/asset/v1/asset_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSET_V1_MOCKS_MOCK_ASSET_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSET_V1_MOCKS_MOCK_ASSET_CONNECTION_H

#include "google/cloud/asset/v1/asset_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace asset_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `AssetServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `AssetServiceClient`. To do so,
 * construct an object of type `AssetServiceClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockAssetServiceConnection : public asset_v1::AssetServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ExportAssets(Matcher<google::cloud::asset::v1::ExportAssetsRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::asset::v1::ExportAssetsResponse>>,
              ExportAssets,
              (google::cloud::asset::v1::ExportAssetsRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, ExportAssets(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, ExportAssets,
              (NoAwaitTag,
               google::cloud::asset::v1::ExportAssetsRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, ExportAssets(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::asset::v1::ExportAssetsResponse>>,
              ExportAssets, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::asset::v1::Asset>), ListAssets,
              (google::cloud::asset::v1::ListAssetsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::asset::v1::BatchGetAssetsHistoryResponse>,
      BatchGetAssetsHistory,
      (google::cloud::asset::v1::BatchGetAssetsHistoryRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::asset::v1::Feed>, CreateFeed,
              (google::cloud::asset::v1::CreateFeedRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::asset::v1::Feed>, GetFeed,
              (google::cloud::asset::v1::GetFeedRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::asset::v1::ListFeedsResponse>, ListFeeds,
              (google::cloud::asset::v1::ListFeedsRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::asset::v1::Feed>, UpdateFeed,
              (google::cloud::asset::v1::UpdateFeedRequest const& request),
              (override));

  MOCK_METHOD(Status, DeleteFeed,
              (google::cloud::asset::v1::DeleteFeedRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::asset::v1::ResourceSearchResult>),
              SearchAllResources,
              (google::cloud::asset::v1::SearchAllResourcesRequest request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::asset::v1::IamPolicySearchResult>),
              SearchAllIamPolicies,
              (google::cloud::asset::v1::SearchAllIamPoliciesRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyResponse>,
      AnalyzeIamPolicy,
      (google::cloud::asset::v1::AnalyzeIamPolicyRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// AnalyzeIamPolicyLongrunning(Matcher<google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>>,
      AnalyzeIamPolicyLongrunning,
      (google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, AnalyzeIamPolicyLongrunning(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, AnalyzeIamPolicyLongrunning,
      (NoAwaitTag,
       google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// AnalyzeIamPolicyLongrunning(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>>,
      AnalyzeIamPolicyLongrunning,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(StatusOr<google::cloud::asset::v1::AnalyzeMoveResponse>,
              AnalyzeMove,
              (google::cloud::asset::v1::AnalyzeMoveRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::asset::v1::QueryAssetsResponse>,
              QueryAssets,
              (google::cloud::asset::v1::QueryAssetsRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::asset::v1::SavedQuery>, CreateSavedQuery,
      (google::cloud::asset::v1::CreateSavedQueryRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::asset::v1::SavedQuery>, GetSavedQuery,
              (google::cloud::asset::v1::GetSavedQueryRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::asset::v1::SavedQuery>),
              ListSavedQueries,
              (google::cloud::asset::v1::ListSavedQueriesRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::asset::v1::SavedQuery>, UpdateSavedQuery,
      (google::cloud::asset::v1::UpdateSavedQueryRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeleteSavedQuery,
      (google::cloud::asset::v1::DeleteSavedQueryRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::asset::v1::BatchGetEffectiveIamPoliciesResponse>,
      BatchGetEffectiveIamPolicies,
      (google::cloud::asset::v1::BatchGetEffectiveIamPoliciesRequest const&
           request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::asset::v1::
                               AnalyzeOrgPoliciesResponse::OrgPolicyResult>),
              AnalyzeOrgPolicies,
              (google::cloud::asset::v1::AnalyzeOrgPoliciesRequest request),
              (override));

  MOCK_METHOD(
      (StreamRange<
          google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersResponse::
              GovernedContainer>),
      AnalyzeOrgPolicyGovernedContainers,
      (google::cloud::asset::v1::AnalyzeOrgPolicyGovernedContainersRequest
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::asset::v1::
                       AnalyzeOrgPolicyGovernedAssetsResponse::GovernedAsset>),
      AnalyzeOrgPolicyGovernedAssets,
      (google::cloud::asset::v1::AnalyzeOrgPolicyGovernedAssetsRequest request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace asset_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSET_V1_MOCKS_MOCK_ASSET_CONNECTION_H
