// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATATRANSFER_V1_INTERNAL_DATA_TRANSFER_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATATRANSFER_V1_INTERNAL_DATA_TRANSFER_TRACING_CONNECTION_H

#include "google/cloud/bigquery/datatransfer/v1/data_transfer_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_datatransfer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class DataTransferServiceTracingConnection
    : public bigquery_datatransfer_v1::DataTransferServiceConnection {
 public:
  ~DataTransferServiceTracingConnection() override = default;

  explicit DataTransferServiceTracingConnection(
      std::shared_ptr<bigquery_datatransfer_v1::DataTransferServiceConnection>
          child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::bigquery::datatransfer::v1::DataSource> GetDataSource(
      google::cloud::bigquery::datatransfer::v1::GetDataSourceRequest const&
          request) override;

  StreamRange<google::cloud::bigquery::datatransfer::v1::DataSource>
  ListDataSources(
      google::cloud::bigquery::datatransfer::v1::ListDataSourcesRequest request)
      override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  CreateTransferConfig(google::cloud::bigquery::datatransfer::v1::
                           CreateTransferConfigRequest const& request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  UpdateTransferConfig(google::cloud::bigquery::datatransfer::v1::
                           UpdateTransferConfigRequest const& request) override;

  Status DeleteTransferConfig(
      google::cloud::bigquery::datatransfer::v1::
          DeleteTransferConfigRequest const& request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  GetTransferConfig(
      google::cloud::bigquery::datatransfer::v1::GetTransferConfigRequest const&
          request) override;

  StreamRange<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  ListTransferConfigs(
      google::cloud::bigquery::datatransfer::v1::ListTransferConfigsRequest
          request) override;

  StatusOr<
      google::cloud::bigquery::datatransfer::v1::ScheduleTransferRunsResponse>
  ScheduleTransferRuns(google::cloud::bigquery::datatransfer::v1::
                           ScheduleTransferRunsRequest const& request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::
               StartManualTransferRunsResponse>
  StartManualTransferRuns(
      google::cloud::bigquery::datatransfer::v1::
          StartManualTransferRunsRequest const& request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::TransferRun>
  GetTransferRun(
      google::cloud::bigquery::datatransfer::v1::GetTransferRunRequest const&
          request) override;

  Status DeleteTransferRun(
      google::cloud::bigquery::datatransfer::v1::DeleteTransferRunRequest const&
          request) override;

  StreamRange<google::cloud::bigquery::datatransfer::v1::TransferRun>
  ListTransferRuns(
      google::cloud::bigquery::datatransfer::v1::ListTransferRunsRequest
          request) override;

  StreamRange<google::cloud::bigquery::datatransfer::v1::TransferMessage>
  ListTransferLogs(
      google::cloud::bigquery::datatransfer::v1::ListTransferLogsRequest
          request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::CheckValidCredsResponse>
  CheckValidCreds(
      google::cloud::bigquery::datatransfer::v1::CheckValidCredsRequest const&
          request) override;

  Status EnrollDataSources(
      google::cloud::bigquery::datatransfer::v1::EnrollDataSourcesRequest const&
          request) override;

  Status UnenrollDataSources(
      google::cloud::bigquery::datatransfer::v1::
          UnenrollDataSourcesRequest const& request) override;

 private:
  std::shared_ptr<bigquery_datatransfer_v1::DataTransferServiceConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<bigquery_datatransfer_v1::DataTransferServiceConnection>
MakeDataTransferServiceTracingConnection(
    std::shared_ptr<bigquery_datatransfer_v1::DataTransferServiceConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_datatransfer_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATATRANSFER_V1_INTERNAL_DATA_TRANSFER_TRACING_CONNECTION_H
