// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/reservation/v1/reservation.proto

#include "google/cloud/bigquery/reservation/v1/internal/reservation_option_defaults.h"
#include "google/cloud/bigquery/reservation/v1/reservation_connection.h"
#include "google/cloud/bigquery/reservation/v1/reservation_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_reservation_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options ReservationServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_RESERVATION_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_RESERVATION_SERVICE_AUTHORITY",
      "bigqueryreservation.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<
          bigquery_reservation_v1::ReservationServiceRetryPolicyOption>()) {
    options.set<bigquery_reservation_v1::ReservationServiceRetryPolicyOption>(
        bigquery_reservation_v1::ReservationServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<
          bigquery_reservation_v1::ReservationServiceBackoffPolicyOption>()) {
    options.set<bigquery_reservation_v1::ReservationServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<bigquery_reservation_v1::
                       ReservationServiceConnectionIdempotencyPolicyOption>()) {
    options.set<bigquery_reservation_v1::
                    ReservationServiceConnectionIdempotencyPolicyOption>(
        bigquery_reservation_v1::
            MakeDefaultReservationServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_reservation_v1_internal
}  // namespace cloud
}  // namespace google
