// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/routine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_ROUTINE_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_ROUTINE_REST_CONNECTION_IMPL_H

#include "google/cloud/bigquerycontrol/v2/internal/routine_rest_stub.h"
#include "google/cloud/bigquerycontrol/v2/internal/routine_retry_traits.h"
#include "google/cloud/bigquerycontrol/v2/routine_connection.h"
#include "google/cloud/bigquerycontrol/v2/routine_connection_idempotency_policy.h"
#include "google/cloud/bigquerycontrol/v2/routine_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RoutineServiceRestConnectionImpl
    : public bigquerycontrol_v2::RoutineServiceConnection {
 public:
  ~RoutineServiceRestConnectionImpl() override = default;

  RoutineServiceRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<bigquerycontrol_v2_internal::RoutineServiceRestStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::bigquery::v2::Routine> GetRoutine(
      google::cloud::bigquery::v2::GetRoutineRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Routine> InsertRoutine(
      google::cloud::bigquery::v2::InsertRoutineRequest const& request)
      override;

  StatusOr<google::cloud::bigquery::v2::Routine> UpdateRoutine(
      google::cloud::bigquery::v2::UpdateRoutineRequest const& request)
      override;

  Status DeleteRoutine(google::cloud::bigquery::v2::DeleteRoutineRequest const&
                           request) override;

  StatusOr<google::cloud::bigquery::v2::ListRoutinesResponse> ListRoutines(
      google::cloud::bigquery::v2::ListRoutinesRequest const& request) override;

 private:
  static std::unique_ptr<bigquerycontrol_v2::RoutineServiceRetryPolicy>
  retry_policy(Options const& options) {
    return options.get<bigquerycontrol_v2::RoutineServiceRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options.get<bigquerycontrol_v2::RoutineServiceBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<
      bigquerycontrol_v2::RoutineServiceConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<bigquerycontrol_v2::
                 RoutineServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<bigquerycontrol_v2_internal::RoutineServiceRestStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_ROUTINE_REST_CONNECTION_IMPL_H
