// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/job.proto

#include "google/cloud/bigquerycontrol/v2/job_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

JobServiceConnectionIdempotencyPolicy::
    ~JobServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<JobServiceConnectionIdempotencyPolicy>
JobServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<JobServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency JobServiceConnectionIdempotencyPolicy::CancelJob(
    google::cloud::bigquery::v2::CancelJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::GetJob(
    google::cloud::bigquery::v2::GetJobRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::InsertJob(
    google::cloud::bigquery::v2::InsertJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::DeleteJob(
    google::cloud::bigquery::v2::DeleteJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::ListJobs(
    google::cloud::bigquery::v2::ListJobsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::GetQueryResults(
    google::cloud::bigquery::v2::GetQueryResultsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency JobServiceConnectionIdempotencyPolicy::Query(
    google::cloud::bigquery::v2::PostQueryRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<JobServiceConnectionIdempotencyPolicy>
MakeDefaultJobServiceConnectionIdempotencyPolicy() {
  return std::make_unique<JobServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google
