// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/model.proto

#include "google/cloud/bigquerycontrol/v2/model_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ModelServiceConnectionIdempotencyPolicy::
    ~ModelServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<ModelServiceConnectionIdempotencyPolicy>
ModelServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ModelServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency ModelServiceConnectionIdempotencyPolicy::GetModel(
    google::cloud::bigquery::v2::GetModelRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ModelServiceConnectionIdempotencyPolicy::ListModels(
    google::cloud::bigquery::v2::ListModelsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ModelServiceConnectionIdempotencyPolicy::PatchModel(
    google::cloud::bigquery::v2::PatchModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ModelServiceConnectionIdempotencyPolicy::DeleteModel(
    google::cloud::bigquery::v2::DeleteModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ModelServiceConnectionIdempotencyPolicy>
MakeDefaultModelServiceConnectionIdempotencyPolicy() {
  return std::make_unique<ModelServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google
