// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_core_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/cloudcontrolspartner/v1/core.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudControlsPartnerCoreLogging::CloudControlsPartnerCoreLogging(
    std::shared_ptr<CloudControlsPartnerCoreStub> child,
    TracingOptions tracing_options, std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::cloudcontrolspartner::v1::Workload>
CloudControlsPartnerCoreLogging::GetWorkload(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
                 request) {
        return child_->GetWorkload(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cloudcontrolspartner::v1::ListWorkloadsResponse>
CloudControlsPartnerCoreLogging::ListWorkloads(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest const&
              request) {
        return child_->ListWorkloads(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Customer>
CloudControlsPartnerCoreLogging::GetCustomer(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
                 request) {
        return child_->GetCustomer(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cloudcontrolspartner::v1::ListCustomersResponse>
CloudControlsPartnerCoreLogging::ListCustomers(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::ListCustomersRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::cloudcontrolspartner::v1::ListCustomersRequest const&
              request) {
        return child_->ListCustomers(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
CloudControlsPartnerCoreLogging::GetEkmConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::
                 GetEkmConnectionsRequest const& request) {
        return child_->GetEkmConnections(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
CloudControlsPartnerCoreLogging::GetPartnerPermissions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetPartnerPermissionsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::
                 GetPartnerPermissionsRequest const& request) {
        return child_->GetPartnerPermissions(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<
    google::cloud::cloudcontrolspartner::v1::ListAccessApprovalRequestsResponse>
CloudControlsPartnerCoreLogging::ListAccessApprovalRequests(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::
        ListAccessApprovalRequestsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::
                 ListAccessApprovalRequestsRequest const& request) {
        return child_->ListAccessApprovalRequests(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Partner>
CloudControlsPartnerCoreLogging::GetPartner(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const&
                 request) {
        return child_->GetPartner(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google
