// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/monitoring.proto

#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_monitoring_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/cloudcontrolspartner/v1/monitoring.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudControlsPartnerMonitoringLogging::CloudControlsPartnerMonitoringLogging(
    std::shared_ptr<CloudControlsPartnerMonitoringStub> child,
    TracingOptions tracing_options, std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::cloudcontrolspartner::v1::ListViolationsResponse>
CloudControlsPartnerMonitoringLogging::ListViolations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::ListViolationsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::cloudcontrolspartner::v1::ListViolationsRequest const&
              request) {
        return child_->ListViolations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringLogging::GetViolation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::cloudcontrolspartner::v1::GetViolationRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::cloudcontrolspartner::v1::GetViolationRequest const&
                 request) {
        return child_->GetViolation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google
