// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/cloudquotas/v1/cloudquotas.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDQUOTAS_V1_MOCKS_MOCK_CLOUD_QUOTAS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDQUOTAS_V1_MOCKS_MOCK_CLOUD_QUOTAS_CONNECTION_H

#include "google/cloud/cloudquotas/v1/cloud_quotas_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace cloudquotas_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `CloudQuotasConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `CloudQuotasClient`. To do so,
 * construct an object of type `CloudQuotasClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockCloudQuotasConnection : public cloudquotas_v1::CloudQuotasConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD((StreamRange<google::api::cloudquotas::v1::QuotaInfo>),
              ListQuotaInfos,
              (google::api::cloudquotas::v1::ListQuotaInfosRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::api::cloudquotas::v1::QuotaInfo>, GetQuotaInfo,
      (google::api::cloudquotas::v1::GetQuotaInfoRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::api::cloudquotas::v1::QuotaPreference>),
      ListQuotaPreferences,
      (google::api::cloudquotas::v1::ListQuotaPreferencesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::api::cloudquotas::v1::QuotaPreference>,
      GetQuotaPreference,
      (google::api::cloudquotas::v1::GetQuotaPreferenceRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::api::cloudquotas::v1::QuotaPreference>,
              CreateQuotaPreference,
              (google::api::cloudquotas::v1::CreateQuotaPreferenceRequest const&
                   request),
              (override));

  MOCK_METHOD(StatusOr<google::api::cloudquotas::v1::QuotaPreference>,
              UpdateQuotaPreference,
              (google::api::cloudquotas::v1::UpdateQuotaPreferenceRequest const&
                   request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudquotas_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDQUOTAS_V1_MOCKS_MOCK_CLOUD_QUOTAS_CONNECTION_H
