// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/network_edge_security_services/v1/network_edge_security_services.proto

#include "google/cloud/compute/network_edge_security_services/v1/network_edge_security_services_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_network_edge_security_services_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NetworkEdgeSecurityServicesClient::NetworkEdgeSecurityServicesClient(
    std::shared_ptr<NetworkEdgeSecurityServicesConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
NetworkEdgeSecurityServicesClient::~NetworkEdgeSecurityServicesClient() =
    default;

StreamRange<std::pair<std::string, google::cloud::cpp::compute::v1::
                                       NetworkEdgeSecurityServicesScopedList>>
NetworkEdgeSecurityServicesClient::AggregatedListNetworkEdgeSecurityServices(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_edge_security_services::v1::
      AggregatedListNetworkEdgeSecurityServicesRequest request;
  request.set_project(project);
  return connection_->AggregatedListNetworkEdgeSecurityServices(request);
}

StreamRange<std::pair<std::string, google::cloud::cpp::compute::v1::
                                       NetworkEdgeSecurityServicesScopedList>>
NetworkEdgeSecurityServicesClient::AggregatedListNetworkEdgeSecurityServices(
    google::cloud::cpp::compute::network_edge_security_services::v1::
        AggregatedListNetworkEdgeSecurityServicesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListNetworkEdgeSecurityServices(
      std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEdgeSecurityServicesClient::DeleteNetworkEdgeSecurityService(
    std::string const& project, std::string const& region,
    std::string const& network_edge_security_service, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_edge_security_services::v1::
      DeleteNetworkEdgeSecurityServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_edge_security_service(network_edge_security_service);
  return connection_->DeleteNetworkEdgeSecurityService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworkEdgeSecurityServicesClient::DeleteNetworkEdgeSecurityService(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& network_edge_security_service, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_edge_security_services::v1::
      DeleteNetworkEdgeSecurityServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_edge_security_service(network_edge_security_service);
  return connection_->DeleteNetworkEdgeSecurityService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEdgeSecurityServicesClient::DeleteNetworkEdgeSecurityService(
    google::cloud::cpp::compute::network_edge_security_services::v1::
        DeleteNetworkEdgeSecurityServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkEdgeSecurityService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworkEdgeSecurityServicesClient::DeleteNetworkEdgeSecurityService(
    NoAwaitTag,
    google::cloud::cpp::compute::network_edge_security_services::v1::
        DeleteNetworkEdgeSecurityServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkEdgeSecurityService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEdgeSecurityServicesClient::DeleteNetworkEdgeSecurityService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkEdgeSecurityService(operation);
}

StatusOr<google::cloud::cpp::compute::v1::NetworkEdgeSecurityService>
NetworkEdgeSecurityServicesClient::GetNetworkEdgeSecurityService(
    std::string const& project, std::string const& region,
    std::string const& network_edge_security_service, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_edge_security_services::v1::
      GetNetworkEdgeSecurityServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_edge_security_service(network_edge_security_service);
  return connection_->GetNetworkEdgeSecurityService(request);
}

StatusOr<google::cloud::cpp::compute::v1::NetworkEdgeSecurityService>
NetworkEdgeSecurityServicesClient::GetNetworkEdgeSecurityService(
    google::cloud::cpp::compute::network_edge_security_services::v1::
        GetNetworkEdgeSecurityServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNetworkEdgeSecurityService(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEdgeSecurityServicesClient::InsertNetworkEdgeSecurityService(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::NetworkEdgeSecurityService const&
        network_edge_security_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_edge_security_services::v1::
      InsertNetworkEdgeSecurityServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_network_edge_security_service_resource() =
      network_edge_security_service_resource;
  return connection_->InsertNetworkEdgeSecurityService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworkEdgeSecurityServicesClient::InsertNetworkEdgeSecurityService(
    NoAwaitTag, std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::NetworkEdgeSecurityService const&
        network_edge_security_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_edge_security_services::v1::
      InsertNetworkEdgeSecurityServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_network_edge_security_service_resource() =
      network_edge_security_service_resource;
  return connection_->InsertNetworkEdgeSecurityService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEdgeSecurityServicesClient::InsertNetworkEdgeSecurityService(
    google::cloud::cpp::compute::network_edge_security_services::v1::
        InsertNetworkEdgeSecurityServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertNetworkEdgeSecurityService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworkEdgeSecurityServicesClient::InsertNetworkEdgeSecurityService(
    NoAwaitTag,
    google::cloud::cpp::compute::network_edge_security_services::v1::
        InsertNetworkEdgeSecurityServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertNetworkEdgeSecurityService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEdgeSecurityServicesClient::InsertNetworkEdgeSecurityService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertNetworkEdgeSecurityService(operation);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEdgeSecurityServicesClient::PatchNetworkEdgeSecurityService(
    std::string const& project, std::string const& region,
    std::string const& network_edge_security_service,
    std::string const& update_mask,
    google::cloud::cpp::compute::v1::NetworkEdgeSecurityService const&
        network_edge_security_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_edge_security_services::v1::
      PatchNetworkEdgeSecurityServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_edge_security_service(network_edge_security_service);
  request.set_update_mask(update_mask);
  *request.mutable_network_edge_security_service_resource() =
      network_edge_security_service_resource;
  return connection_->PatchNetworkEdgeSecurityService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworkEdgeSecurityServicesClient::PatchNetworkEdgeSecurityService(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& network_edge_security_service,
    std::string const& update_mask,
    google::cloud::cpp::compute::v1::NetworkEdgeSecurityService const&
        network_edge_security_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::network_edge_security_services::v1::
      PatchNetworkEdgeSecurityServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_network_edge_security_service(network_edge_security_service);
  request.set_update_mask(update_mask);
  *request.mutable_network_edge_security_service_resource() =
      network_edge_security_service_resource;
  return connection_->PatchNetworkEdgeSecurityService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEdgeSecurityServicesClient::PatchNetworkEdgeSecurityService(
    google::cloud::cpp::compute::network_edge_security_services::v1::
        PatchNetworkEdgeSecurityServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchNetworkEdgeSecurityService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
NetworkEdgeSecurityServicesClient::PatchNetworkEdgeSecurityService(
    NoAwaitTag,
    google::cloud::cpp::compute::network_edge_security_services::v1::
        PatchNetworkEdgeSecurityServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchNetworkEdgeSecurityService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
NetworkEdgeSecurityServicesClient::PatchNetworkEdgeSecurityService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchNetworkEdgeSecurityService(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_network_edge_security_services_v1
}  // namespace cloud
}  // namespace google
