// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/ssl_policies/v1/ssl_policies.proto

#include "google/cloud/compute/ssl_policies/v1/ssl_policies_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_ssl_policies_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SslPoliciesClient::SslPoliciesClient(
    std::shared_ptr<SslPoliciesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SslPoliciesClient::~SslPoliciesClient() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::SslPoliciesScopedList>>
SslPoliciesClient::AggregatedListSslPolicies(std::string const& project,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::
      AggregatedListSslPoliciesRequest request;
  request.set_project(project);
  return connection_->AggregatedListSslPolicies(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::SslPoliciesScopedList>>
SslPoliciesClient::AggregatedListSslPolicies(
    google::cloud::cpp::compute::ssl_policies::v1::
        AggregatedListSslPoliciesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListSslPolicies(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SslPoliciesClient::DeleteSslPolicy(std::string const& project,
                                   std::string const& ssl_policy,
                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::DeleteSslPolicyRequest request;
  request.set_project(project);
  request.set_ssl_policy(ssl_policy);
  return connection_->DeleteSslPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SslPoliciesClient::DeleteSslPolicy(NoAwaitTag, std::string const& project,
                                   std::string const& ssl_policy,
                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::DeleteSslPolicyRequest request;
  request.set_project(project);
  request.set_ssl_policy(ssl_policy);
  return connection_->DeleteSslPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SslPoliciesClient::DeleteSslPolicy(
    google::cloud::cpp::compute::ssl_policies::v1::DeleteSslPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSslPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SslPoliciesClient::DeleteSslPolicy(
    NoAwaitTag,
    google::cloud::cpp::compute::ssl_policies::v1::DeleteSslPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSslPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SslPoliciesClient::DeleteSslPolicy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSslPolicy(operation);
}

StatusOr<google::cloud::cpp::compute::v1::SslPolicy>
SslPoliciesClient::GetSslPolicy(std::string const& project,
                                std::string const& ssl_policy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::GetSslPolicyRequest request;
  request.set_project(project);
  request.set_ssl_policy(ssl_policy);
  return connection_->GetSslPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::SslPolicy>
SslPoliciesClient::GetSslPolicy(
    google::cloud::cpp::compute::ssl_policies::v1::GetSslPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSslPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SslPoliciesClient::InsertSslPolicy(
    std::string const& project,
    google::cloud::cpp::compute::v1::SslPolicy const& ssl_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::InsertSslPolicyRequest request;
  request.set_project(project);
  *request.mutable_ssl_policy_resource() = ssl_policy_resource;
  return connection_->InsertSslPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SslPoliciesClient::InsertSslPolicy(
    NoAwaitTag, std::string const& project,
    google::cloud::cpp::compute::v1::SslPolicy const& ssl_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::InsertSslPolicyRequest request;
  request.set_project(project);
  *request.mutable_ssl_policy_resource() = ssl_policy_resource;
  return connection_->InsertSslPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SslPoliciesClient::InsertSslPolicy(
    google::cloud::cpp::compute::ssl_policies::v1::InsertSslPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertSslPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SslPoliciesClient::InsertSslPolicy(
    NoAwaitTag,
    google::cloud::cpp::compute::ssl_policies::v1::InsertSslPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertSslPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SslPoliciesClient::InsertSslPolicy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertSslPolicy(operation);
}

StreamRange<google::cloud::cpp::compute::v1::SslPolicy>
SslPoliciesClient::ListSslPolicies(std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::ListSslPoliciesRequest request;
  request.set_project(project);
  return connection_->ListSslPolicies(request);
}

StreamRange<google::cloud::cpp::compute::v1::SslPolicy>
SslPoliciesClient::ListSslPolicies(
    google::cloud::cpp::compute::ssl_policies::v1::ListSslPoliciesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSslPolicies(std::move(request));
}

StatusOr<
    google::cloud::cpp::compute::v1::SslPoliciesListAvailableFeaturesResponse>
SslPoliciesClient::ListAvailableFeatures(std::string const& project,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::ListAvailableFeaturesRequest
      request;
  request.set_project(project);
  return connection_->ListAvailableFeatures(request);
}

StatusOr<
    google::cloud::cpp::compute::v1::SslPoliciesListAvailableFeaturesResponse>
SslPoliciesClient::ListAvailableFeatures(
    google::cloud::cpp::compute::ssl_policies::v1::
        ListAvailableFeaturesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAvailableFeatures(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SslPoliciesClient::PatchSslPolicy(
    std::string const& project, std::string const& ssl_policy,
    google::cloud::cpp::compute::v1::SslPolicy const& ssl_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::PatchSslPolicyRequest request;
  request.set_project(project);
  request.set_ssl_policy(ssl_policy);
  *request.mutable_ssl_policy_resource() = ssl_policy_resource;
  return connection_->PatchSslPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SslPoliciesClient::PatchSslPolicy(
    NoAwaitTag, std::string const& project, std::string const& ssl_policy,
    google::cloud::cpp::compute::v1::SslPolicy const& ssl_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::ssl_policies::v1::PatchSslPolicyRequest request;
  request.set_project(project);
  request.set_ssl_policy(ssl_policy);
  *request.mutable_ssl_policy_resource() = ssl_policy_resource;
  return connection_->PatchSslPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SslPoliciesClient::PatchSslPolicy(
    google::cloud::cpp::compute::ssl_policies::v1::PatchSslPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchSslPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SslPoliciesClient::PatchSslPolicy(
    NoAwaitTag,
    google::cloud::cpp::compute::ssl_policies::v1::PatchSslPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchSslPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SslPoliciesClient::PatchSslPolicy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchSslPolicy(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_ssl_policies_v1
}  // namespace cloud
}  // namespace google
