// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_service.proto

#include "google/cloud/contentwarehouse/v1/internal/document_auth_decorator.h"
#include <google/cloud/contentwarehouse/v1/document_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DocumentServiceAuth::DocumentServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<DocumentServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::contentwarehouse::v1::CreateDocumentResponse>
DocumentServiceAuth::CreateDocument(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contentwarehouse::v1::CreateDocumentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateDocument(context, options, request);
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DocumentServiceAuth::GetDocument(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contentwarehouse::v1::GetDocumentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetDocument(context, options, request);
}

StatusOr<google::cloud::contentwarehouse::v1::UpdateDocumentResponse>
DocumentServiceAuth::UpdateDocument(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contentwarehouse::v1::UpdateDocumentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateDocument(context, options, request);
}

Status DocumentServiceAuth::DeleteDocument(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contentwarehouse::v1::DeleteDocumentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteDocument(context, options, request);
}

StatusOr<google::cloud::contentwarehouse::v1::SearchDocumentsResponse>
DocumentServiceAuth::SearchDocuments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contentwarehouse::v1::SearchDocumentsRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SearchDocuments(context, options, request);
}

StatusOr<google::cloud::contentwarehouse::v1::Document>
DocumentServiceAuth::LockDocument(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contentwarehouse::v1::LockDocumentRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->LockDocument(context, options, request);
}

StatusOr<google::cloud::contentwarehouse::v1::FetchAclResponse>
DocumentServiceAuth::FetchAcl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contentwarehouse::v1::FetchAclRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->FetchAcl(context, options, request);
}

StatusOr<google::cloud::contentwarehouse::v1::SetAclResponse>
DocumentServiceAuth::SetAcl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::contentwarehouse::v1::SetAclRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SetAcl(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
