// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/data_taxonomy.proto

#include "google/cloud/dataplex/v1/data_taxonomy_connection.h"
#include "google/cloud/dataplex/v1/data_taxonomy_options.h"
#include "google/cloud/dataplex/v1/internal/data_taxonomy_connection_impl.h"
#include "google/cloud/dataplex/v1/internal/data_taxonomy_option_defaults.h"
#include "google/cloud/dataplex/v1/internal/data_taxonomy_stub_factory.h"
#include "google/cloud/dataplex/v1/internal/data_taxonomy_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataTaxonomyServiceConnection::~DataTaxonomyServiceConnection() = default;

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceConnection::CreateDataTaxonomy(
    google::cloud::dataplex::v1::CreateDataTaxonomyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnection::CreateDataTaxonomy(
    NoAwaitTag, google::cloud::dataplex::v1::CreateDataTaxonomyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceConnection::CreateDataTaxonomy(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceConnection::UpdateDataTaxonomy(
    google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnection::UpdateDataTaxonomy(
    NoAwaitTag, google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceConnection::UpdateDataTaxonomy(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnection::DeleteDataTaxonomy(
    google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnection::DeleteDataTaxonomy(
    NoAwaitTag, google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnection::DeleteDataTaxonomy(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::dataplex::v1::DataTaxonomy>
DataTaxonomyServiceConnection::ListDataTaxonomies(
    google::cloud::dataplex::v1::
        ListDataTaxonomiesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataTaxonomy>>();
}

StatusOr<google::cloud::dataplex::v1::DataTaxonomy>
DataTaxonomyServiceConnection::GetDataTaxonomy(
    google::cloud::dataplex::v1::GetDataTaxonomyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceConnection::CreateDataAttributeBinding(
    google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnection::CreateDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceConnection::CreateDataAttributeBinding(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceConnection::UpdateDataAttributeBinding(
    google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnection::UpdateDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceConnection::UpdateDataAttributeBinding(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnection::DeleteDataAttributeBinding(
    google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnection::DeleteDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnection::DeleteDataAttributeBinding(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::dataplex::v1::DataAttributeBinding>
DataTaxonomyServiceConnection::ListDataAttributeBindings(
    google::cloud::dataplex::v1::
        ListDataAttributeBindingsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataAttributeBinding>>();
}

StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>
DataTaxonomyServiceConnection::GetDataAttributeBinding(
    google::cloud::dataplex::v1::GetDataAttributeBindingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceConnection::CreateDataAttribute(
    google::cloud::dataplex::v1::CreateDataAttributeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataAttribute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnection::CreateDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataAttributeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceConnection::CreateDataAttribute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataAttribute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceConnection::UpdateDataAttribute(
    google::cloud::dataplex::v1::UpdateDataAttributeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataAttribute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnection::UpdateDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataAttributeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceConnection::UpdateDataAttribute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::DataAttribute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnection::DeleteDataAttribute(
    google::cloud::dataplex::v1::DeleteDataAttributeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnection::DeleteDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataAttributeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnection::DeleteDataAttribute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::dataplex::v1::DataAttribute>
DataTaxonomyServiceConnection::ListDataAttributes(
    google::cloud::dataplex::v1::
        ListDataAttributesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataAttribute>>();
}

StatusOr<google::cloud::dataplex::v1::DataAttribute>
DataTaxonomyServiceConnection::GetDataAttribute(
    google::cloud::dataplex::v1::GetDataAttributeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DataTaxonomyServiceConnection>
MakeDataTaxonomyServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DataTaxonomyServicePolicyOptionList>(options,
                                                                      __func__);
  options = dataplex_v1_internal::DataTaxonomyServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = dataplex_v1_internal::CreateDefaultDataTaxonomyServiceStub(
      std::move(auth), options);
  return dataplex_v1_internal::MakeDataTaxonomyServiceTracingConnection(
      std::make_shared<dataplex_v1_internal::DataTaxonomyServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
