// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/developerconnect/v1/developer_connect.proto

#include "google/cloud/developerconnect/v1/developer_connect_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace developerconnect_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DeveloperConnectConnectionIdempotencyPolicy::
    ~DeveloperConnectConnectionIdempotencyPolicy() = default;

std::unique_ptr<DeveloperConnectConnectionIdempotencyPolicy>
DeveloperConnectConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DeveloperConnectConnectionIdempotencyPolicy>(*this);
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::ListConnections(
    google::cloud::developerconnect::v1::ListConnectionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::GetConnection(
    google::cloud::developerconnect::v1::GetConnectionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::CreateConnection(
    google::cloud::developerconnect::v1::CreateConnectionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::UpdateConnection(
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::DeleteConnection(
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
DeveloperConnectConnectionIdempotencyPolicy::CreateGitRepositoryLink(
    google::cloud::developerconnect::v1::
        CreateGitRepositoryLinkRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
DeveloperConnectConnectionIdempotencyPolicy::DeleteGitRepositoryLink(
    google::cloud::developerconnect::v1::
        DeleteGitRepositoryLinkRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::ListGitRepositoryLinks(
    google::cloud::developerconnect::v1::
        ListGitRepositoryLinksRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::GetGitRepositoryLink(
    google::cloud::developerconnect::v1::GetGitRepositoryLinkRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::FetchReadWriteToken(
    google::cloud::developerconnect::v1::FetchReadWriteTokenRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::FetchReadToken(
    google::cloud::developerconnect::v1::FetchReadTokenRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
DeveloperConnectConnectionIdempotencyPolicy::FetchLinkableGitRepositories(
    google::cloud::developerconnect::v1::
        FetchLinkableGitRepositoriesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
DeveloperConnectConnectionIdempotencyPolicy::FetchGitHubInstallations(
    google::cloud::developerconnect::v1::
        FetchGitHubInstallationsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DeveloperConnectConnectionIdempotencyPolicy::FetchGitRefs(
    google::cloud::developerconnect::v1::FetchGitRefsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<DeveloperConnectConnectionIdempotencyPolicy>
MakeDefaultDeveloperConnectConnectionIdempotencyPolicy() {
  return std::make_unique<DeveloperConnectConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace developerconnect_v1
}  // namespace cloud
}  // namespace google
