// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/entity_type.proto

#include "google/cloud/dialogflow_es/entity_types_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EntityTypesClient::EntityTypesClient(
    std::shared_ptr<EntityTypesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
EntityTypesClient::~EntityTypesClient() = default;

StreamRange<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::ListEntityTypes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ListEntityTypesRequest request;
  request.set_parent(parent);
  return connection_->ListEntityTypes(request);
}

StreamRange<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::ListEntityTypes(std::string const& parent,
                                   std::string const& language_code,
                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ListEntityTypesRequest request;
  request.set_parent(parent);
  request.set_language_code(language_code);
  return connection_->ListEntityTypes(request);
}

StreamRange<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::ListEntityTypes(
    google::cloud::dialogflow::v2::ListEntityTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEntityTypes(std::move(request));
}

StatusOr<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::GetEntityType(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::GetEntityTypeRequest request;
  request.set_name(name);
  return connection_->GetEntityType(request);
}

StatusOr<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::GetEntityType(std::string const& name,
                                 std::string const& language_code,
                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::GetEntityTypeRequest request;
  request.set_name(name);
  request.set_language_code(language_code);
  return connection_->GetEntityType(request);
}

StatusOr<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::GetEntityType(
    google::cloud::dialogflow::v2::GetEntityTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEntityType(request);
}

StatusOr<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::CreateEntityType(
    std::string const& parent,
    google::cloud::dialogflow::v2::EntityType const& entity_type,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::CreateEntityTypeRequest request;
  request.set_parent(parent);
  *request.mutable_entity_type() = entity_type;
  return connection_->CreateEntityType(request);
}

StatusOr<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::CreateEntityType(
    std::string const& parent,
    google::cloud::dialogflow::v2::EntityType const& entity_type,
    std::string const& language_code, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::CreateEntityTypeRequest request;
  request.set_parent(parent);
  *request.mutable_entity_type() = entity_type;
  request.set_language_code(language_code);
  return connection_->CreateEntityType(request);
}

StatusOr<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::CreateEntityType(
    google::cloud::dialogflow::v2::CreateEntityTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEntityType(request);
}

StatusOr<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::UpdateEntityType(
    google::cloud::dialogflow::v2::EntityType const& entity_type,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::UpdateEntityTypeRequest request;
  *request.mutable_entity_type() = entity_type;
  return connection_->UpdateEntityType(request);
}

StatusOr<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::UpdateEntityType(
    google::cloud::dialogflow::v2::EntityType const& entity_type,
    std::string const& language_code, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::UpdateEntityTypeRequest request;
  *request.mutable_entity_type() = entity_type;
  request.set_language_code(language_code);
  return connection_->UpdateEntityType(request);
}

StatusOr<google::cloud::dialogflow::v2::EntityType>
EntityTypesClient::UpdateEntityType(
    google::cloud::dialogflow::v2::UpdateEntityTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEntityType(request);
}

Status EntityTypesClient::DeleteEntityType(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::DeleteEntityTypeRequest request;
  request.set_name(name);
  return connection_->DeleteEntityType(request);
}

Status EntityTypesClient::DeleteEntityType(
    google::cloud::dialogflow::v2::DeleteEntityTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEntityType(request);
}

future<StatusOr<google::cloud::dialogflow::v2::BatchUpdateEntityTypesResponse>>
EntityTypesClient::BatchUpdateEntityTypes(
    google::cloud::dialogflow::v2::BatchUpdateEntityTypesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchUpdateEntityTypes(request);
}

StatusOr<google::longrunning::Operation>
EntityTypesClient::BatchUpdateEntityTypes(
    NoAwaitTag,
    google::cloud::dialogflow::v2::BatchUpdateEntityTypesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchUpdateEntityTypes(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::BatchUpdateEntityTypesResponse>>
EntityTypesClient::BatchUpdateEntityTypes(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchUpdateEntityTypes(operation);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchDeleteEntityTypes(
    std::string const& parent,
    std::vector<std::string> const& entity_type_names, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchDeleteEntityTypesRequest request;
  request.set_parent(parent);
  *request.mutable_entity_type_names() = {entity_type_names.begin(),
                                          entity_type_names.end()};
  return connection_->BatchDeleteEntityTypes(request);
}

StatusOr<google::longrunning::Operation>
EntityTypesClient::BatchDeleteEntityTypes(
    NoAwaitTag, std::string const& parent,
    std::vector<std::string> const& entity_type_names, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchDeleteEntityTypesRequest request;
  request.set_parent(parent);
  *request.mutable_entity_type_names() = {entity_type_names.begin(),
                                          entity_type_names.end()};
  return connection_->BatchDeleteEntityTypes(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchDeleteEntityTypes(
    google::cloud::dialogflow::v2::BatchDeleteEntityTypesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteEntityTypes(request);
}

StatusOr<google::longrunning::Operation>
EntityTypesClient::BatchDeleteEntityTypes(
    NoAwaitTag,
    google::cloud::dialogflow::v2::BatchDeleteEntityTypesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteEntityTypes(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchDeleteEntityTypes(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteEntityTypes(operation);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchCreateEntities(
    std::string const& parent,
    std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
        entities,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchCreateEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entities() = {entities.begin(), entities.end()};
  return connection_->BatchCreateEntities(request);
}

StatusOr<google::longrunning::Operation> EntityTypesClient::BatchCreateEntities(
    NoAwaitTag, std::string const& parent,
    std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
        entities,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchCreateEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entities() = {entities.begin(), entities.end()};
  return connection_->BatchCreateEntities(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchCreateEntities(
    std::string const& parent,
    std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
        entities,
    std::string const& language_code, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchCreateEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entities() = {entities.begin(), entities.end()};
  request.set_language_code(language_code);
  return connection_->BatchCreateEntities(request);
}

StatusOr<google::longrunning::Operation> EntityTypesClient::BatchCreateEntities(
    NoAwaitTag, std::string const& parent,
    std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
        entities,
    std::string const& language_code, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchCreateEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entities() = {entities.begin(), entities.end()};
  request.set_language_code(language_code);
  return connection_->BatchCreateEntities(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchCreateEntities(
    google::cloud::dialogflow::v2::BatchCreateEntitiesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCreateEntities(request);
}

StatusOr<google::longrunning::Operation> EntityTypesClient::BatchCreateEntities(
    NoAwaitTag,
    google::cloud::dialogflow::v2::BatchCreateEntitiesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCreateEntities(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchCreateEntities(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchCreateEntities(operation);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchUpdateEntities(
    std::string const& parent,
    std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
        entities,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchUpdateEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entities() = {entities.begin(), entities.end()};
  return connection_->BatchUpdateEntities(request);
}

StatusOr<google::longrunning::Operation> EntityTypesClient::BatchUpdateEntities(
    NoAwaitTag, std::string const& parent,
    std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
        entities,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchUpdateEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entities() = {entities.begin(), entities.end()};
  return connection_->BatchUpdateEntities(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchUpdateEntities(
    std::string const& parent,
    std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
        entities,
    std::string const& language_code, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchUpdateEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entities() = {entities.begin(), entities.end()};
  request.set_language_code(language_code);
  return connection_->BatchUpdateEntities(request);
}

StatusOr<google::longrunning::Operation> EntityTypesClient::BatchUpdateEntities(
    NoAwaitTag, std::string const& parent,
    std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
        entities,
    std::string const& language_code, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchUpdateEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entities() = {entities.begin(), entities.end()};
  request.set_language_code(language_code);
  return connection_->BatchUpdateEntities(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchUpdateEntities(
    google::cloud::dialogflow::v2::BatchUpdateEntitiesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchUpdateEntities(request);
}

StatusOr<google::longrunning::Operation> EntityTypesClient::BatchUpdateEntities(
    NoAwaitTag,
    google::cloud::dialogflow::v2::BatchUpdateEntitiesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchUpdateEntities(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchUpdateEntities(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchUpdateEntities(operation);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchDeleteEntities(
    std::string const& parent, std::vector<std::string> const& entity_values,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchDeleteEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entity_values() = {entity_values.begin(),
                                      entity_values.end()};
  return connection_->BatchDeleteEntities(request);
}

StatusOr<google::longrunning::Operation> EntityTypesClient::BatchDeleteEntities(
    NoAwaitTag, std::string const& parent,
    std::vector<std::string> const& entity_values, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchDeleteEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entity_values() = {entity_values.begin(),
                                      entity_values.end()};
  return connection_->BatchDeleteEntities(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchDeleteEntities(
    std::string const& parent, std::vector<std::string> const& entity_values,
    std::string const& language_code, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchDeleteEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entity_values() = {entity_values.begin(),
                                      entity_values.end()};
  request.set_language_code(language_code);
  return connection_->BatchDeleteEntities(request);
}

StatusOr<google::longrunning::Operation> EntityTypesClient::BatchDeleteEntities(
    NoAwaitTag, std::string const& parent,
    std::vector<std::string> const& entity_values,
    std::string const& language_code, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::BatchDeleteEntitiesRequest request;
  request.set_parent(parent);
  *request.mutable_entity_values() = {entity_values.begin(),
                                      entity_values.end()};
  request.set_language_code(language_code);
  return connection_->BatchDeleteEntities(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchDeleteEntities(
    google::cloud::dialogflow::v2::BatchDeleteEntitiesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteEntities(request);
}

StatusOr<google::longrunning::Operation> EntityTypesClient::BatchDeleteEntities(
    NoAwaitTag,
    google::cloud::dialogflow::v2::BatchDeleteEntitiesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteEntities(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>>
EntityTypesClient::BatchDeleteEntities(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteEntities(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
