// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/session_entity_type.proto

#include "google/cloud/dialogflow_es/internal/session_entity_types_connection_impl.h"
#include "google/cloud/dialogflow_es/internal/session_entity_types_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dialogflow_es::SessionEntityTypesRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dialogflow_es::SessionEntityTypesRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<dialogflow_es::SessionEntityTypesBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<dialogflow_es::SessionEntityTypesConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dialogflow_es::SessionEntityTypesConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

SessionEntityTypesConnectionImpl::SessionEntityTypesConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dialogflow_es_internal::SessionEntityTypesStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), SessionEntityTypesConnection::options())) {}

StreamRange<google::cloud::dialogflow::v2::SessionEntityType>
SessionEntityTypesConnectionImpl::ListSessionEntityTypes(
    google::cloud::dialogflow::v2::ListSessionEntityTypesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListSessionEntityTypes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dialogflow::v2::SessionEntityType>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dialogflow_es::SessionEntityTypesRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dialogflow::v2::ListSessionEntityTypesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dialogflow::v2::
                       ListSessionEntityTypesRequest const& request) {
              return stub->ListSessionEntityTypes(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dialogflow::v2::ListSessionEntityTypesResponse r) {
        std::vector<google::cloud::dialogflow::v2::SessionEntityType> result(
            r.session_entity_types().size());
        auto& messages = *r.mutable_session_entity_types();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dialogflow::v2::SessionEntityType>
SessionEntityTypesConnectionImpl::GetSessionEntityType(
    google::cloud::dialogflow::v2::GetSessionEntityTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSessionEntityType(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dialogflow::v2::GetSessionEntityTypeRequest const&
                 request) {
        return stub_->GetSessionEntityType(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dialogflow::v2::SessionEntityType>
SessionEntityTypesConnectionImpl::CreateSessionEntityType(
    google::cloud::dialogflow::v2::CreateSessionEntityTypeRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSessionEntityType(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dialogflow::v2::CreateSessionEntityTypeRequest const&
              request) {
        return stub_->CreateSessionEntityType(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dialogflow::v2::SessionEntityType>
SessionEntityTypesConnectionImpl::UpdateSessionEntityType(
    google::cloud::dialogflow::v2::UpdateSessionEntityTypeRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSessionEntityType(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dialogflow::v2::UpdateSessionEntityTypeRequest const&
              request) {
        return stub_->UpdateSessionEntityType(context, options, request);
      },
      *current, request, __func__);
}

Status SessionEntityTypesConnectionImpl::DeleteSessionEntityType(
    google::cloud::dialogflow::v2::DeleteSessionEntityTypeRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSessionEntityType(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dialogflow::v2::DeleteSessionEntityTypeRequest const&
              request) {
        return stub_->DeleteSessionEntityType(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
