// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/domains/v1/domains.proto

#include "google/cloud/domains/v1/domains_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace domains_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DomainsClient::DomainsClient(std::shared_ptr<DomainsConnection> connection,
                             Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DomainsClient::~DomainsClient() = default;

StatusOr<google::cloud::domains::v1::SearchDomainsResponse>
DomainsClient::SearchDomains(std::string const& location,
                             std::string const& query, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::SearchDomainsRequest request;
  request.set_location(location);
  request.set_query(query);
  return connection_->SearchDomains(request);
}

StatusOr<google::cloud::domains::v1::SearchDomainsResponse>
DomainsClient::SearchDomains(
    google::cloud::domains::v1::SearchDomainsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchDomains(request);
}

StatusOr<google::cloud::domains::v1::RetrieveRegisterParametersResponse>
DomainsClient::RetrieveRegisterParameters(std::string const& location,
                                          std::string const& domain_name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::RetrieveRegisterParametersRequest request;
  request.set_location(location);
  request.set_domain_name(domain_name);
  return connection_->RetrieveRegisterParameters(request);
}

StatusOr<google::cloud::domains::v1::RetrieveRegisterParametersResponse>
DomainsClient::RetrieveRegisterParameters(
    google::cloud::domains::v1::RetrieveRegisterParametersRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RetrieveRegisterParameters(request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::RegisterDomain(
    std::string const& parent,
    google::cloud::domains::v1::Registration const& registration,
    google::type::Money const& yearly_price, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::RegisterDomainRequest request;
  request.set_parent(parent);
  *request.mutable_registration() = registration;
  *request.mutable_yearly_price() = yearly_price;
  return connection_->RegisterDomain(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::RegisterDomain(
    NoAwaitTag, std::string const& parent,
    google::cloud::domains::v1::Registration const& registration,
    google::type::Money const& yearly_price, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::RegisterDomainRequest request;
  request.set_parent(parent);
  *request.mutable_registration() = registration;
  *request.mutable_yearly_price() = yearly_price;
  return connection_->RegisterDomain(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::RegisterDomain(
    google::cloud::domains::v1::RegisterDomainRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RegisterDomain(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::RegisterDomain(
    NoAwaitTag,
    google::cloud::domains::v1::RegisterDomainRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RegisterDomain(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::RegisterDomain(google::longrunning::Operation const& operation,
                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RegisterDomain(operation);
}

StatusOr<google::cloud::domains::v1::RetrieveTransferParametersResponse>
DomainsClient::RetrieveTransferParameters(std::string const& location,
                                          std::string const& domain_name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::RetrieveTransferParametersRequest request;
  request.set_location(location);
  request.set_domain_name(domain_name);
  return connection_->RetrieveTransferParameters(request);
}

StatusOr<google::cloud::domains::v1::RetrieveTransferParametersResponse>
DomainsClient::RetrieveTransferParameters(
    google::cloud::domains::v1::RetrieveTransferParametersRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RetrieveTransferParameters(request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::TransferDomain(
    std::string const& parent,
    google::cloud::domains::v1::Registration const& registration,
    google::type::Money const& yearly_price,
    google::cloud::domains::v1::AuthorizationCode const& authorization_code,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::TransferDomainRequest request;
  request.set_parent(parent);
  *request.mutable_registration() = registration;
  *request.mutable_yearly_price() = yearly_price;
  *request.mutable_authorization_code() = authorization_code;
  return connection_->TransferDomain(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::TransferDomain(
    NoAwaitTag, std::string const& parent,
    google::cloud::domains::v1::Registration const& registration,
    google::type::Money const& yearly_price,
    google::cloud::domains::v1::AuthorizationCode const& authorization_code,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::TransferDomainRequest request;
  request.set_parent(parent);
  *request.mutable_registration() = registration;
  *request.mutable_yearly_price() = yearly_price;
  *request.mutable_authorization_code() = authorization_code;
  return connection_->TransferDomain(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::TransferDomain(
    google::cloud::domains::v1::TransferDomainRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TransferDomain(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::TransferDomain(
    NoAwaitTag,
    google::cloud::domains::v1::TransferDomainRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TransferDomain(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::TransferDomain(google::longrunning::Operation const& operation,
                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TransferDomain(operation);
}

StreamRange<google::cloud::domains::v1::Registration>
DomainsClient::ListRegistrations(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ListRegistrationsRequest request;
  request.set_parent(parent);
  return connection_->ListRegistrations(request);
}

StreamRange<google::cloud::domains::v1::Registration>
DomainsClient::ListRegistrations(
    google::cloud::domains::v1::ListRegistrationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRegistrations(std::move(request));
}

StatusOr<google::cloud::domains::v1::Registration>
DomainsClient::GetRegistration(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::GetRegistrationRequest request;
  request.set_name(name);
  return connection_->GetRegistration(request);
}

StatusOr<google::cloud::domains::v1::Registration>
DomainsClient::GetRegistration(
    google::cloud::domains::v1::GetRegistrationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRegistration(request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::UpdateRegistration(
    google::cloud::domains::v1::Registration const& registration,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::UpdateRegistrationRequest request;
  *request.mutable_registration() = registration;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateRegistration(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::UpdateRegistration(
    NoAwaitTag, google::cloud::domains::v1::Registration const& registration,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::UpdateRegistrationRequest request;
  *request.mutable_registration() = registration;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateRegistration(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::UpdateRegistration(
    google::cloud::domains::v1::UpdateRegistrationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRegistration(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::UpdateRegistration(
    NoAwaitTag,
    google::cloud::domains::v1::UpdateRegistrationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRegistration(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::UpdateRegistration(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRegistration(operation);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ConfigureManagementSettings(
    std::string const& registration,
    google::cloud::domains::v1::ManagementSettings const& management_settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ConfigureManagementSettingsRequest request;
  request.set_registration(registration);
  *request.mutable_management_settings() = management_settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->ConfigureManagementSettings(request);
}

StatusOr<google::longrunning::Operation>
DomainsClient::ConfigureManagementSettings(
    NoAwaitTag, std::string const& registration,
    google::cloud::domains::v1::ManagementSettings const& management_settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ConfigureManagementSettingsRequest request;
  request.set_registration(registration);
  *request.mutable_management_settings() = management_settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->ConfigureManagementSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ConfigureManagementSettings(
    google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConfigureManagementSettings(request);
}

StatusOr<google::longrunning::Operation>
DomainsClient::ConfigureManagementSettings(
    NoAwaitTag,
    google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConfigureManagementSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ConfigureManagementSettings(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConfigureManagementSettings(operation);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ConfigureDnsSettings(
    std::string const& registration,
    google::cloud::domains::v1::DnsSettings const& dns_settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ConfigureDnsSettingsRequest request;
  request.set_registration(registration);
  *request.mutable_dns_settings() = dns_settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->ConfigureDnsSettings(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::ConfigureDnsSettings(
    NoAwaitTag, std::string const& registration,
    google::cloud::domains::v1::DnsSettings const& dns_settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ConfigureDnsSettingsRequest request;
  request.set_registration(registration);
  *request.mutable_dns_settings() = dns_settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->ConfigureDnsSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ConfigureDnsSettings(
    google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConfigureDnsSettings(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::ConfigureDnsSettings(
    NoAwaitTag,
    google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConfigureDnsSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ConfigureDnsSettings(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConfigureDnsSettings(operation);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ConfigureContactSettings(
    std::string const& registration,
    google::cloud::domains::v1::ContactSettings const& contact_settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ConfigureContactSettingsRequest request;
  request.set_registration(registration);
  *request.mutable_contact_settings() = contact_settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->ConfigureContactSettings(request);
}

StatusOr<google::longrunning::Operation>
DomainsClient::ConfigureContactSettings(
    NoAwaitTag, std::string const& registration,
    google::cloud::domains::v1::ContactSettings const& contact_settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ConfigureContactSettingsRequest request;
  request.set_registration(registration);
  *request.mutable_contact_settings() = contact_settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->ConfigureContactSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ConfigureContactSettings(
    google::cloud::domains::v1::ConfigureContactSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConfigureContactSettings(request);
}

StatusOr<google::longrunning::Operation>
DomainsClient::ConfigureContactSettings(
    NoAwaitTag,
    google::cloud::domains::v1::ConfigureContactSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConfigureContactSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ConfigureContactSettings(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ConfigureContactSettings(operation);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ExportRegistration(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ExportRegistrationRequest request;
  request.set_name(name);
  return connection_->ExportRegistration(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::ExportRegistration(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ExportRegistrationRequest request;
  request.set_name(name);
  return connection_->ExportRegistration(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ExportRegistration(
    google::cloud::domains::v1::ExportRegistrationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportRegistration(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::ExportRegistration(
    NoAwaitTag,
    google::cloud::domains::v1::ExportRegistrationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportRegistration(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsClient::ExportRegistration(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportRegistration(operation);
}

future<StatusOr<google::cloud::domains::v1::OperationMetadata>>
DomainsClient::DeleteRegistration(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::DeleteRegistrationRequest request;
  request.set_name(name);
  return connection_->DeleteRegistration(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::DeleteRegistration(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::DeleteRegistrationRequest request;
  request.set_name(name);
  return connection_->DeleteRegistration(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::OperationMetadata>>
DomainsClient::DeleteRegistration(
    google::cloud::domains::v1::DeleteRegistrationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRegistration(request);
}

StatusOr<google::longrunning::Operation> DomainsClient::DeleteRegistration(
    NoAwaitTag,
    google::cloud::domains::v1::DeleteRegistrationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRegistration(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::domains::v1::OperationMetadata>>
DomainsClient::DeleteRegistration(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRegistration(operation);
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DomainsClient::RetrieveAuthorizationCode(std::string const& registration,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::RetrieveAuthorizationCodeRequest request;
  request.set_registration(registration);
  return connection_->RetrieveAuthorizationCode(request);
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DomainsClient::RetrieveAuthorizationCode(
    google::cloud::domains::v1::RetrieveAuthorizationCodeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RetrieveAuthorizationCode(request);
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DomainsClient::ResetAuthorizationCode(std::string const& registration,
                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::domains::v1::ResetAuthorizationCodeRequest request;
  request.set_registration(registration);
  return connection_->ResetAuthorizationCode(request);
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DomainsClient::ResetAuthorizationCode(
    google::cloud::domains::v1::ResetAuthorizationCodeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetAuthorizationCode(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace domains_v1
}  // namespace cloud
}  // namespace google
