// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/iam/v1/iam_policy.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAM_V1_IAM_POLICY_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAM_V1_IAM_POLICY_CONNECTION_H

#include "google/cloud/iam/v1/iam_policy_connection_idempotency_policy.h"
#include "google/cloud/iam/v1/internal/iam_policy_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/iam/v1/iam_policy.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace iam_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `IAMPolicyConnection`.
class IAMPolicyRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<IAMPolicyRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `IAMPolicyConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class IAMPolicyLimitedErrorCountRetryPolicy : public IAMPolicyRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit IAMPolicyLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  IAMPolicyLimitedErrorCountRetryPolicy(
      IAMPolicyLimitedErrorCountRetryPolicy&& rhs) noexcept
      : IAMPolicyLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  IAMPolicyLimitedErrorCountRetryPolicy(
      IAMPolicyLimitedErrorCountRetryPolicy const& rhs) noexcept
      : IAMPolicyLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<IAMPolicyRetryPolicy> clone() const override {
    return std::make_unique<IAMPolicyLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = IAMPolicyRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      iam_v1_internal::IAMPolicyRetryTraits>
      impl_;
};

/**
 * A retry policy for `IAMPolicyConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class IAMPolicyLimitedTimeRetryPolicy : public IAMPolicyRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit IAMPolicyLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  IAMPolicyLimitedTimeRetryPolicy(
      IAMPolicyLimitedTimeRetryPolicy&& rhs) noexcept
      : IAMPolicyLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  IAMPolicyLimitedTimeRetryPolicy(
      IAMPolicyLimitedTimeRetryPolicy const& rhs) noexcept
      : IAMPolicyLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<IAMPolicyRetryPolicy> clone() const override {
    return std::make_unique<IAMPolicyLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = IAMPolicyRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      iam_v1_internal::IAMPolicyRetryTraits>
      impl_;
};

/**
 * The `IAMPolicyConnection` object for `IAMPolicyClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `IAMPolicyClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `IAMPolicyClient`.
 *
 * To create a concrete instance, see `MakeIAMPolicyConnection()`.
 *
 * For mocking, see `iam_v1_mocks::MockIAMPolicyConnection`.
 */
class IAMPolicyConnection {
 public:
  virtual ~IAMPolicyConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);
};

/**
 * A factory function to construct an object of type `IAMPolicyConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of IAMPolicyClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `IAMPolicyConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::iam_v1::IAMPolicyPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `IAMPolicyConnection` created by
 * this function.
 */
std::shared_ptr<IAMPolicyConnection> MakeIAMPolicyConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iam_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAM_V1_IAM_POLICY_CONNECTION_H
