// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/autokey_admin.proto

#include "google/cloud/kms/v1/internal/autokey_admin_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace kms_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AutokeyAdminTracingConnection::AutokeyAdminTracingConnection(
    std::shared_ptr<kms_v1::AutokeyAdminConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::kms::v1::AutokeyConfig>
AutokeyAdminTracingConnection::UpdateAutokeyConfig(
    google::cloud::kms::v1::UpdateAutokeyConfigRequest const& request) {
  auto span =
      internal::MakeSpan("kms_v1::AutokeyAdminConnection::UpdateAutokeyConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateAutokeyConfig(request));
}

StatusOr<google::cloud::kms::v1::AutokeyConfig>
AutokeyAdminTracingConnection::GetAutokeyConfig(
    google::cloud::kms::v1::GetAutokeyConfigRequest const& request) {
  auto span =
      internal::MakeSpan("kms_v1::AutokeyAdminConnection::GetAutokeyConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAutokeyConfig(request));
}

StatusOr<google::cloud::kms::v1::ShowEffectiveAutokeyConfigResponse>
AutokeyAdminTracingConnection::ShowEffectiveAutokeyConfig(
    google::cloud::kms::v1::ShowEffectiveAutokeyConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "kms_v1::AutokeyAdminConnection::ShowEffectiveAutokeyConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ShowEffectiveAutokeyConfig(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<kms_v1::AutokeyAdminConnection>
MakeAutokeyAdminTracingConnection(
    std::shared_ptr<kms_v1::AutokeyAdminConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<AutokeyAdminTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1_internal
}  // namespace cloud
}  // namespace google
