// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networksecurity/v1/network_security.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_INTERNAL_NETWORK_SECURITY_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_INTERNAL_NETWORK_SECURITY_TRACING_CONNECTION_H

#include "google/cloud/networksecurity/v1/network_security_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace networksecurity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class NetworkSecurityTracingConnection
    : public networksecurity_v1::NetworkSecurityConnection {
 public:
  ~NetworkSecurityTracingConnection() override = default;

  explicit NetworkSecurityTracingConnection(
      std::shared_ptr<networksecurity_v1::NetworkSecurityConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::networksecurity::v1::AuthorizationPolicy>
  ListAuthorizationPolicies(
      google::cloud::networksecurity::v1::ListAuthorizationPoliciesRequest
          request) override;

  StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>
  GetAuthorizationPolicy(
      google::cloud::networksecurity::v1::GetAuthorizationPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  CreateAuthorizationPolicy(
      google::cloud::networksecurity::v1::
          CreateAuthorizationPolicyRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateAuthorizationPolicy(
      NoAwaitTag, google::cloud::networksecurity::v1::
                      CreateAuthorizationPolicyRequest const& request) override;

  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  CreateAuthorizationPolicy(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  UpdateAuthorizationPolicy(
      google::cloud::networksecurity::v1::
          UpdateAuthorizationPolicyRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateAuthorizationPolicy(
      NoAwaitTag, google::cloud::networksecurity::v1::
                      UpdateAuthorizationPolicyRequest const& request) override;

  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  UpdateAuthorizationPolicy(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteAuthorizationPolicy(
      google::cloud::networksecurity::v1::
          DeleteAuthorizationPolicyRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteAuthorizationPolicy(
      NoAwaitTag, google::cloud::networksecurity::v1::
                      DeleteAuthorizationPolicyRequest const& request) override;

  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteAuthorizationPolicy(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::networksecurity::v1::ServerTlsPolicy>
  ListServerTlsPolicies(
      google::cloud::networksecurity::v1::ListServerTlsPoliciesRequest request)
      override;

  StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>
  GetServerTlsPolicy(
      google::cloud::networksecurity::v1::GetServerTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  CreateServerTlsPolicy(
      google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateServerTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  CreateServerTlsPolicy(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  UpdateServerTlsPolicy(
      google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateServerTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  UpdateServerTlsPolicy(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteServerTlsPolicy(
      google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteServerTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteServerTlsPolicy(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::networksecurity::v1::ClientTlsPolicy>
  ListClientTlsPolicies(
      google::cloud::networksecurity::v1::ListClientTlsPoliciesRequest request)
      override;

  StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>
  GetClientTlsPolicy(
      google::cloud::networksecurity::v1::GetClientTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  CreateClientTlsPolicy(
      google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateClientTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  CreateClientTlsPolicy(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  UpdateClientTlsPolicy(
      google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateClientTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  UpdateClientTlsPolicy(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteClientTlsPolicy(
      google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteClientTlsPolicy(
      NoAwaitTag,
      google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteClientTlsPolicy(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<networksecurity_v1::NetworkSecurityConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<networksecurity_v1::NetworkSecurityConnection>
MakeNetworkSecurityTracingConnection(
    std::shared_ptr<networksecurity_v1::NetworkSecurityConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networksecurity_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_INTERNAL_NETWORK_SECURITY_TRACING_CONNECTION_H
