// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_NETWORK_SERVICES_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_NETWORK_SERVICES_CONNECTION_H

#include "google/cloud/networkservices/v1/internal/network_services_retry_traits.h"
#include "google/cloud/networkservices/v1/network_services_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/networkservices/v1/network_services.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace networkservices_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `NetworkServicesConnection`.
class NetworkServicesRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<NetworkServicesRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `NetworkServicesConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class NetworkServicesLimitedErrorCountRetryPolicy
    : public NetworkServicesRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit NetworkServicesLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  NetworkServicesLimitedErrorCountRetryPolicy(
      NetworkServicesLimitedErrorCountRetryPolicy&& rhs) noexcept
      : NetworkServicesLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  NetworkServicesLimitedErrorCountRetryPolicy(
      NetworkServicesLimitedErrorCountRetryPolicy const& rhs) noexcept
      : NetworkServicesLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<NetworkServicesRetryPolicy> clone() const override {
    return std::make_unique<NetworkServicesLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = NetworkServicesRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      networkservices_v1_internal::NetworkServicesRetryTraits>
      impl_;
};

/**
 * A retry policy for `NetworkServicesConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class NetworkServicesLimitedTimeRetryPolicy
    : public NetworkServicesRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit NetworkServicesLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  NetworkServicesLimitedTimeRetryPolicy(
      NetworkServicesLimitedTimeRetryPolicy&& rhs) noexcept
      : NetworkServicesLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  NetworkServicesLimitedTimeRetryPolicy(
      NetworkServicesLimitedTimeRetryPolicy const& rhs) noexcept
      : NetworkServicesLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<NetworkServicesRetryPolicy> clone() const override {
    return std::make_unique<NetworkServicesLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = NetworkServicesRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      networkservices_v1_internal::NetworkServicesRetryTraits>
      impl_;
};

/**
 * The `NetworkServicesConnection` object for `NetworkServicesClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `NetworkServicesClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `NetworkServicesClient`.
 *
 * To create a concrete instance, see `MakeNetworkServicesConnection()`.
 *
 * For mocking, see `networkservices_v1_mocks::MockNetworkServicesConnection`.
 */
class NetworkServicesConnection {
 public:
  virtual ~NetworkServicesConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::networkservices::v1::EndpointPolicy>
  ListEndpointPolicies(
      google::cloud::networkservices::v1::ListEndpointPoliciesRequest request);

  virtual StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
  GetEndpointPolicy(
      google::cloud::networkservices::v1::GetEndpointPolicyRequest const&
          request);

  virtual future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  CreateEndpointPolicy(
      google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateEndpointPolicy(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
          request);

  virtual future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  CreateEndpointPolicy(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  UpdateEndpointPolicy(
      google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> UpdateEndpointPolicy(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
          request);

  virtual future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  UpdateEndpointPolicy(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteEndpointPolicy(
      google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteEndpointPolicy(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteEndpointPolicy(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::networkservices::v1::Gateway> ListGateways(
      google::cloud::networkservices::v1::ListGatewaysRequest request);

  virtual StatusOr<google::cloud::networkservices::v1::Gateway> GetGateway(
      google::cloud::networkservices::v1::GetGatewayRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::Gateway>>
  CreateGateway(
      google::cloud::networkservices::v1::CreateGatewayRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateGateway(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateGatewayRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::Gateway>>
  CreateGateway(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::networkservices::v1::Gateway>>
  UpdateGateway(
      google::cloud::networkservices::v1::UpdateGatewayRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateGateway(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateGatewayRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::Gateway>>
  UpdateGateway(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGateway(
      google::cloud::networkservices::v1::DeleteGatewayRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteGateway(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteGatewayRequest const& request);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGateway(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::networkservices::v1::GrpcRoute>
  ListGrpcRoutes(
      google::cloud::networkservices::v1::ListGrpcRoutesRequest request);

  virtual StatusOr<google::cloud::networkservices::v1::GrpcRoute> GetGrpcRoute(
      google::cloud::networkservices::v1::GetGrpcRouteRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  CreateGrpcRoute(
      google::cloud::networkservices::v1::CreateGrpcRouteRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateGrpcRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateGrpcRouteRequest const&
          request);

  virtual future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  CreateGrpcRoute(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  UpdateGrpcRoute(
      google::cloud::networkservices::v1::UpdateGrpcRouteRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> UpdateGrpcRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateGrpcRouteRequest const&
          request);

  virtual future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  UpdateGrpcRoute(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGrpcRoute(
      google::cloud::networkservices::v1::DeleteGrpcRouteRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteGrpcRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteGrpcRouteRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGrpcRoute(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::networkservices::v1::HttpRoute>
  ListHttpRoutes(
      google::cloud::networkservices::v1::ListHttpRoutesRequest request);

  virtual StatusOr<google::cloud::networkservices::v1::HttpRoute> GetHttpRoute(
      google::cloud::networkservices::v1::GetHttpRouteRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  CreateHttpRoute(
      google::cloud::networkservices::v1::CreateHttpRouteRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateHttpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateHttpRouteRequest const&
          request);

  virtual future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  CreateHttpRoute(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  UpdateHttpRoute(
      google::cloud::networkservices::v1::UpdateHttpRouteRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> UpdateHttpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateHttpRouteRequest const&
          request);

  virtual future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  UpdateHttpRoute(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteHttpRoute(
      google::cloud::networkservices::v1::DeleteHttpRouteRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteHttpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteHttpRouteRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteHttpRoute(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::networkservices::v1::TcpRoute>
  ListTcpRoutes(
      google::cloud::networkservices::v1::ListTcpRoutesRequest request);

  virtual StatusOr<google::cloud::networkservices::v1::TcpRoute> GetTcpRoute(
      google::cloud::networkservices::v1::GetTcpRouteRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
  CreateTcpRoute(
      google::cloud::networkservices::v1::CreateTcpRouteRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateTcpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateTcpRouteRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
  CreateTcpRoute(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
  UpdateTcpRoute(
      google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateTcpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
  UpdateTcpRoute(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTcpRoute(
      google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteTcpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTcpRoute(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::networkservices::v1::TlsRoute>
  ListTlsRoutes(
      google::cloud::networkservices::v1::ListTlsRoutesRequest request);

  virtual StatusOr<google::cloud::networkservices::v1::TlsRoute> GetTlsRoute(
      google::cloud::networkservices::v1::GetTlsRouteRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
  CreateTlsRoute(
      google::cloud::networkservices::v1::CreateTlsRouteRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateTlsRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateTlsRouteRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
  CreateTlsRoute(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
  UpdateTlsRoute(
      google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateTlsRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
  UpdateTlsRoute(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTlsRoute(
      google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteTlsRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTlsRoute(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::networkservices::v1::ServiceBinding>
  ListServiceBindings(
      google::cloud::networkservices::v1::ListServiceBindingsRequest request);

  virtual StatusOr<google::cloud::networkservices::v1::ServiceBinding>
  GetServiceBinding(
      google::cloud::networkservices::v1::GetServiceBindingRequest const&
          request);

  virtual future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
  CreateServiceBinding(
      google::cloud::networkservices::v1::CreateServiceBindingRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateServiceBinding(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateServiceBindingRequest const&
          request);

  virtual future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
  CreateServiceBinding(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteServiceBinding(
      google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteServiceBinding(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
          request);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteServiceBinding(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::networkservices::v1::Mesh> ListMeshes(
      google::cloud::networkservices::v1::ListMeshesRequest request);

  virtual StatusOr<google::cloud::networkservices::v1::Mesh> GetMesh(
      google::cloud::networkservices::v1::GetMeshRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::Mesh>> CreateMesh(
      google::cloud::networkservices::v1::CreateMeshRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateMesh(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateMeshRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::Mesh>> CreateMesh(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::networkservices::v1::Mesh>> UpdateMesh(
      google::cloud::networkservices::v1::UpdateMeshRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateMesh(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateMeshRequest const& request);

  virtual future<StatusOr<google::cloud::networkservices::v1::Mesh>> UpdateMesh(
      google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteMesh(
      google::cloud::networkservices::v1::DeleteMeshRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteMesh(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteMeshRequest const& request);

  virtual future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteMesh(google::longrunning::Operation const& operation);
};

/**
 * A factory function to construct an object of type
 * `NetworkServicesConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of NetworkServicesClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `NetworkServicesConnection`. Expected options are any of the types
 * in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::networkservices_v1::NetworkServicesPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `NetworkServicesConnection` created
 * by this function.
 */
std::shared_ptr<NetworkServicesConnection> MakeNetworkServicesConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_NETWORK_SERVICES_CONNECTION_H
