// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v2/service.proto

#include "google/cloud/notebooks/v2/internal/notebook_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace notebooks_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NotebookServiceTracingStub::NotebookServiceTracingStub(
    std::shared_ptr<NotebookServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::notebooks::v2::ListInstancesResponse>
NotebookServiceTracingStub::ListInstances(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v2::ListInstancesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "ListInstances");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListInstances(context, options, request));
}

StatusOr<google::cloud::notebooks::v2::Instance>
NotebookServiceTracingStub::GetInstance(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v2::GetInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "GetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncCreateInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v2::CreateInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "CreateInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::CreateInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v2::CreateInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "CreateInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncUpdateInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v2::UpdateInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "UpdateInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::UpdateInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v2::UpdateInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "UpdateInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncDeleteInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v2::DeleteInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "DeleteInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::DeleteInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v2::DeleteInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "DeleteInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncStartInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v2::StartInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "StartInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncStartInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::StartInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v2::StartInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "StartInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->StartInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncStopInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v2::StopInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "StopInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncStopInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::StopInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v2::StopInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "StopInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->StopInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncResetInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v2::ResetInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "ResetInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncResetInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::ResetInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v2::ResetInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "ResetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ResetInstance(context, options, request));
}

StatusOr<google::cloud::notebooks::v2::CheckInstanceUpgradabilityResponse>
NotebookServiceTracingStub::CheckInstanceUpgradability(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v2::CheckInstanceUpgradabilityRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.notebooks.v2.NotebookService",
                             "CheckInstanceUpgradability");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->CheckInstanceUpgradability(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncUpgradeInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v2::UpgradeInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "UpgradeInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpgradeInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::UpgradeInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v2::UpgradeInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "UpgradeInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpgradeInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncRollbackInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v2::RollbackInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "RollbackInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncRollbackInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::RollbackInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v2::RollbackInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "RollbackInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RollbackInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncDiagnoseInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v2::DiagnoseInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "DiagnoseInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDiagnoseInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::DiagnoseInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v2::DiagnoseInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v2.NotebookService", "DiagnoseInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DiagnoseInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> NotebookServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<NotebookServiceStub> MakeNotebookServiceTracingStub(
    std::shared_ptr<NotebookServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<NotebookServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v2_internal
}  // namespace cloud
}  // namespace google
