// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v2/service.proto

#include "google/cloud/notebooks/v2/notebook_connection.h"
#include "google/cloud/notebooks/v2/internal/notebook_connection_impl.h"
#include "google/cloud/notebooks/v2/internal/notebook_option_defaults.h"
#include "google/cloud/notebooks/v2/internal/notebook_stub_factory.h"
#include "google/cloud/notebooks/v2/internal/notebook_tracing_connection.h"
#include "google/cloud/notebooks/v2/notebook_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace notebooks_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NotebookServiceConnection::~NotebookServiceConnection() = default;

StreamRange<google::cloud::notebooks::v2::Instance>
NotebookServiceConnection::ListInstances(
    google::cloud::notebooks::v2::
        ListInstancesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::notebooks::v2::Instance>>();
}

StatusOr<google::cloud::notebooks::v2::Instance>
NotebookServiceConnection::GetInstance(
    google::cloud::notebooks::v2::GetInstanceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::CreateInstance(
    google::cloud::notebooks::v2::CreateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NotebookServiceConnection::CreateInstance(
    NoAwaitTag, google::cloud::notebooks::v2::CreateInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::CreateInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::UpdateInstance(
    google::cloud::notebooks::v2::UpdateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NotebookServiceConnection::UpdateInstance(
    NoAwaitTag, google::cloud::notebooks::v2::UpdateInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::UpdateInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::OperationMetadata>>
NotebookServiceConnection::DeleteInstance(
    google::cloud::notebooks::v2::DeleteInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NotebookServiceConnection::DeleteInstance(
    NoAwaitTag, google::cloud::notebooks::v2::DeleteInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::OperationMetadata>>
NotebookServiceConnection::DeleteInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::StartInstance(
    google::cloud::notebooks::v2::StartInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NotebookServiceConnection::StartInstance(
    NoAwaitTag, google::cloud::notebooks::v2::StartInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::StartInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::StopInstance(
    google::cloud::notebooks::v2::StopInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NotebookServiceConnection::StopInstance(
    NoAwaitTag, google::cloud::notebooks::v2::StopInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::StopInstance(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::ResetInstance(
    google::cloud::notebooks::v2::ResetInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NotebookServiceConnection::ResetInstance(
    NoAwaitTag, google::cloud::notebooks::v2::ResetInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::ResetInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::notebooks::v2::CheckInstanceUpgradabilityResponse>
NotebookServiceConnection::CheckInstanceUpgradability(
    google::cloud::notebooks::v2::CheckInstanceUpgradabilityRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::UpgradeInstance(
    google::cloud::notebooks::v2::UpgradeInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NotebookServiceConnection::UpgradeInstance(
    NoAwaitTag, google::cloud::notebooks::v2::UpgradeInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::UpgradeInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::RollbackInstance(
    google::cloud::notebooks::v2::RollbackInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NotebookServiceConnection::RollbackInstance(
    NoAwaitTag, google::cloud::notebooks::v2::RollbackInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::RollbackInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::DiagnoseInstance(
    google::cloud::notebooks::v2::DiagnoseInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
NotebookServiceConnection::DiagnoseInstance(
    NoAwaitTag, google::cloud::notebooks::v2::DiagnoseInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v2::Instance>>
NotebookServiceConnection::DiagnoseInstance(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v2::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<NotebookServiceConnection> MakeNotebookServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 NotebookServicePolicyOptionList>(options,
                                                                  __func__);
  options =
      notebooks_v2_internal::NotebookServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = notebooks_v2_internal::CreateDefaultNotebookServiceStub(
      std::move(auth), options);
  return notebooks_v2_internal::MakeNotebookServiceTracingConnection(
      std::make_shared<notebooks_v2_internal::NotebookServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v2
}  // namespace cloud
}  // namespace google
