// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#include "google/cloud/pubsub/internal/subscriber_round_robin_decorator.h"
#include <memory>
#include <mutex>
#include <vector>

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SubscriberRoundRobin::SubscriberRoundRobin(
    std::vector<std::shared_ptr<SubscriberStub>> children)
    : children_(std::move(children)) {}

StatusOr<google::pubsub::v1::Subscription>
SubscriberRoundRobin::CreateSubscription(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::Subscription const& request) {
  return Child()->CreateSubscription(context, options, request);
}

StatusOr<google::pubsub::v1::Subscription>
SubscriberRoundRobin::GetSubscription(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::GetSubscriptionRequest const& request) {
  return Child()->GetSubscription(context, options, request);
}

StatusOr<google::pubsub::v1::Subscription>
SubscriberRoundRobin::UpdateSubscription(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::UpdateSubscriptionRequest const& request) {
  return Child()->UpdateSubscription(context, options, request);
}

StatusOr<google::pubsub::v1::ListSubscriptionsResponse>
SubscriberRoundRobin::ListSubscriptions(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::ListSubscriptionsRequest const& request) {
  return Child()->ListSubscriptions(context, options, request);
}

Status SubscriberRoundRobin::DeleteSubscription(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::DeleteSubscriptionRequest const& request) {
  return Child()->DeleteSubscription(context, options, request);
}

StatusOr<google::pubsub::v1::PullResponse> SubscriberRoundRobin::Pull(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::PullRequest const& request) {
  return Child()->Pull(context, options, request);
}

std::unique_ptr<google::cloud::AsyncStreamingReadWriteRpc<
    google::pubsub::v1::StreamingPullRequest,
    google::pubsub::v1::StreamingPullResponse>>
SubscriberRoundRobin::AsyncStreamingPull(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  return Child()->AsyncStreamingPull(cq, std::move(context),
                                     std::move(options));
}

Status SubscriberRoundRobin::ModifyPushConfig(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::ModifyPushConfigRequest const& request) {
  return Child()->ModifyPushConfig(context, options, request);
}

StatusOr<google::pubsub::v1::Snapshot> SubscriberRoundRobin::GetSnapshot(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::GetSnapshotRequest const& request) {
  return Child()->GetSnapshot(context, options, request);
}

StatusOr<google::pubsub::v1::ListSnapshotsResponse>
SubscriberRoundRobin::ListSnapshots(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::ListSnapshotsRequest const& request) {
  return Child()->ListSnapshots(context, options, request);
}

StatusOr<google::pubsub::v1::Snapshot> SubscriberRoundRobin::CreateSnapshot(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::CreateSnapshotRequest const& request) {
  return Child()->CreateSnapshot(context, options, request);
}

StatusOr<google::pubsub::v1::Snapshot> SubscriberRoundRobin::UpdateSnapshot(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::UpdateSnapshotRequest const& request) {
  return Child()->UpdateSnapshot(context, options, request);
}

Status SubscriberRoundRobin::DeleteSnapshot(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::DeleteSnapshotRequest const& request) {
  return Child()->DeleteSnapshot(context, options, request);
}

StatusOr<google::pubsub::v1::SeekResponse> SubscriberRoundRobin::Seek(
    grpc::ClientContext& context, Options const& options,
    google::pubsub::v1::SeekRequest const& request) {
  return Child()->Seek(context, options, request);
}

StatusOr<google::iam::v1::Policy> SubscriberRoundRobin::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return Child()->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> SubscriberRoundRobin::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return Child()->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SubscriberRoundRobin::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return Child()->TestIamPermissions(context, options, request);
}

future<Status> SubscriberRoundRobin::AsyncModifyAckDeadline(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::pubsub::v1::ModifyAckDeadlineRequest const& request) {
  return Child()->AsyncModifyAckDeadline(cq, std::move(context),
                                         std::move(options), request);
}

future<Status> SubscriberRoundRobin::AsyncAcknowledge(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::pubsub::v1::AcknowledgeRequest const& request) {
  return Child()->AsyncAcknowledge(cq, std::move(context), std::move(options),
                                   request);
}

std::shared_ptr<SubscriberStub> SubscriberRoundRobin::Child() {
  std::unique_lock<std::mutex> lk(mu_);
  auto const current = current_;
  if (++current_ == children_.size()) current_ = 0;
  lk.unlock();
  return children_[current];
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google
