// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/control_service.proto

#include "google/cloud/retail/v2/internal/control_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/retail/v2/control_service.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ControlServiceLogging::ControlServiceLogging(
    std::shared_ptr<ControlServiceStub> child, TracingOptions tracing_options,
    std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::retail::v2::Control>
ControlServiceLogging::CreateControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::CreateControlRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::retail::v2::CreateControlRequest const& request) {
        return child_->CreateControl(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status ControlServiceLogging::DeleteControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::DeleteControlRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::retail::v2::DeleteControlRequest const& request) {
        return child_->DeleteControl(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::retail::v2::Control>
ControlServiceLogging::UpdateControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::UpdateControlRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::retail::v2::UpdateControlRequest const& request) {
        return child_->UpdateControl(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::retail::v2::Control> ControlServiceLogging::GetControl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::GetControlRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::retail::v2::GetControlRequest const& request) {
        return child_->GetControl(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::retail::v2::ListControlsResponse>
ControlServiceLogging::ListControls(
    grpc::ClientContext& context, Options const& options,
    google::cloud::retail::v2::ListControlsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::retail::v2::ListControlsRequest const& request) {
        return child_->ListControls(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google
