// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/serving_config_service.proto

#include "google/cloud/retail/v2/serving_config_connection.h"
#include "google/cloud/retail/v2/internal/serving_config_connection_impl.h"
#include "google/cloud/retail/v2/internal/serving_config_option_defaults.h"
#include "google/cloud/retail/v2/internal/serving_config_stub_factory.h"
#include "google/cloud/retail/v2/internal/serving_config_tracing_connection.h"
#include "google/cloud/retail/v2/serving_config_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServingConfigServiceConnection::~ServingConfigServiceConnection() = default;

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceConnection::CreateServingConfig(
    google::cloud::retail::v2::CreateServingConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ServingConfigServiceConnection::DeleteServingConfig(
    google::cloud::retail::v2::DeleteServingConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceConnection::UpdateServingConfig(
    google::cloud::retail::v2::UpdateServingConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceConnection::GetServingConfig(
    google::cloud::retail::v2::GetServingConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceConnection::ListServingConfigs(
    google::cloud::retail::v2::
        ListServingConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::retail::v2::ServingConfig>>();
}

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceConnection::AddControl(
    google::cloud::retail::v2::AddControlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::retail::v2::ServingConfig>
ServingConfigServiceConnection::RemoveControl(
    google::cloud::retail::v2::RemoveControlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ServingConfigServiceConnection>
MakeServingConfigServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ServingConfigServicePolicyOptionList>(
      options, __func__);
  options = retail_v2_internal::ServingConfigServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = retail_v2_internal::CreateDefaultServingConfigServiceStub(
      std::move(auth), options);
  return retail_v2_internal::MakeServingConfigServiceTracingConnection(
      std::make_shared<retail_v2_internal::ServingConfigServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2
}  // namespace cloud
}  // namespace google
