// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/secretmanager/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECRETMANAGER_V1_INTERNAL_SECRET_MANAGER_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECRETMANAGER_V1_INTERNAL_SECRET_MANAGER_STUB_H

#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/secretmanager/v1/service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace secretmanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SecretManagerServiceStub {
 public:
  virtual ~SecretManagerServiceStub() = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::ListSecretsResponse>
  ListSecrets(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::ListSecretsRequest const& request) = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::Secret> CreateSecret(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::CreateSecretRequest const& request) = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::SecretVersion>
  AddSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::AddSecretVersionRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::Secret> GetSecret(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::GetSecretRequest const& request) = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::Secret> UpdateSecret(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::UpdateSecretRequest const& request) = 0;

  virtual Status DeleteSecret(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::DeleteSecretRequest const& request) = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::ListSecretVersionsResponse>
  ListSecretVersions(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::ListSecretVersionsRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::SecretVersion>
  GetSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::GetSecretVersionRequest const&
          request) = 0;

  virtual StatusOr<
      google::cloud::secretmanager::v1::AccessSecretVersionResponse>
  AccessSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::AccessSecretVersionRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::SecretVersion>
  DisableSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::DisableSecretVersionRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::SecretVersion>
  EnableSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::EnableSecretVersionRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::secretmanager::v1::SecretVersion>
  DestroySecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::DestroySecretVersionRequest const&
          request) = 0;

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) = 0;

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) = 0;

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) = 0;
};

class DefaultSecretManagerServiceStub : public SecretManagerServiceStub {
 public:
  explicit DefaultSecretManagerServiceStub(
      std::unique_ptr<
          google::cloud::secretmanager::v1::SecretManagerService::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::secretmanager::v1::ListSecretsResponse> ListSecrets(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::ListSecretsRequest const& request)
      override;

  StatusOr<google::cloud::secretmanager::v1::Secret> CreateSecret(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::CreateSecretRequest const& request)
      override;

  StatusOr<google::cloud::secretmanager::v1::SecretVersion> AddSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::AddSecretVersionRequest const& request)
      override;

  StatusOr<google::cloud::secretmanager::v1::Secret> GetSecret(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::GetSecretRequest const& request)
      override;

  StatusOr<google::cloud::secretmanager::v1::Secret> UpdateSecret(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::UpdateSecretRequest const& request)
      override;

  Status DeleteSecret(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::DeleteSecretRequest const& request)
      override;

  StatusOr<google::cloud::secretmanager::v1::ListSecretVersionsResponse>
  ListSecretVersions(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::ListSecretVersionsRequest const&
          request) override;

  StatusOr<google::cloud::secretmanager::v1::SecretVersion> GetSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::GetSecretVersionRequest const& request)
      override;

  StatusOr<google::cloud::secretmanager::v1::AccessSecretVersionResponse>
  AccessSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::AccessSecretVersionRequest const&
          request) override;

  StatusOr<google::cloud::secretmanager::v1::SecretVersion>
  DisableSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::DisableSecretVersionRequest const&
          request) override;

  StatusOr<google::cloud::secretmanager::v1::SecretVersion> EnableSecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::EnableSecretVersionRequest const&
          request) override;

  StatusOr<google::cloud::secretmanager::v1::SecretVersion>
  DestroySecretVersion(
      grpc::ClientContext& context, Options const& options,
      google::cloud::secretmanager::v1::DestroySecretVersionRequest const&
          request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

 private:
  std::unique_ptr<
      google::cloud::secretmanager::v1::SecretManagerService::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace secretmanager_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECRETMANAGER_V1_INTERNAL_SECRET_MANAGER_STUB_H
