// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/spanner/v1/spanner.proto

#include "google/cloud/spanner/internal/spanner_auth_decorator.h"
#include <google/spanner/v1/spanner.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace spanner_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SpannerAuth::SpannerAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<SpannerStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::spanner::v1::Session> SpannerAuth::CreateSession(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::CreateSessionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateSession(context, options, request);
}

StatusOr<google::spanner::v1::BatchCreateSessionsResponse>
SpannerAuth::BatchCreateSessions(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::BatchCreateSessionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->BatchCreateSessions(context, options, request);
}

Status SpannerAuth::DeleteSession(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::DeleteSessionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteSession(context, options, request);
}

StatusOr<google::spanner::v1::ResultSet> SpannerAuth::ExecuteSql(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::ExecuteSqlRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ExecuteSql(context, options, request);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<
    google::spanner::v1::PartialResultSet>>
SpannerAuth::ExecuteStreamingSql(
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::spanner::v1::ExecuteSqlRequest const& request) {
  using ErrorStream = ::google::cloud::internal::StreamingReadRpcError<
      google::spanner::v1::PartialResultSet>;
  auto status = auth_->ConfigureContext(*context);
  if (!status.ok()) return std::make_unique<ErrorStream>(std::move(status));
  return child_->ExecuteStreamingSql(std::move(context), options, request);
}

StatusOr<google::spanner::v1::ExecuteBatchDmlResponse>
SpannerAuth::ExecuteBatchDml(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::ExecuteBatchDmlRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ExecuteBatchDml(context, options, request);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<
    google::spanner::v1::PartialResultSet>>
SpannerAuth::StreamingRead(std::shared_ptr<grpc::ClientContext> context,
                           Options const& options,
                           google::spanner::v1::ReadRequest const& request) {
  using ErrorStream = ::google::cloud::internal::StreamingReadRpcError<
      google::spanner::v1::PartialResultSet>;
  auto status = auth_->ConfigureContext(*context);
  if (!status.ok()) return std::make_unique<ErrorStream>(std::move(status));
  return child_->StreamingRead(std::move(context), options, request);
}

StatusOr<google::spanner::v1::Transaction> SpannerAuth::BeginTransaction(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::BeginTransactionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->BeginTransaction(context, options, request);
}

StatusOr<google::spanner::v1::CommitResponse> SpannerAuth::Commit(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::CommitRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->Commit(context, options, request);
}

Status SpannerAuth::Rollback(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::RollbackRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->Rollback(context, options, request);
}

StatusOr<google::spanner::v1::PartitionResponse> SpannerAuth::PartitionQuery(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::PartitionQueryRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->PartitionQuery(context, options, request);
}

StatusOr<google::spanner::v1::PartitionResponse> SpannerAuth::PartitionRead(
    grpc::ClientContext& context, Options const& options,
    google::spanner::v1::PartitionReadRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->PartitionRead(context, options, request);
}

std::unique_ptr<google::cloud::internal::StreamingReadRpc<
    google::spanner::v1::BatchWriteResponse>>
SpannerAuth::BatchWrite(std::shared_ptr<grpc::ClientContext> context,
                        Options const& options,
                        google::spanner::v1::BatchWriteRequest const& request) {
  using ErrorStream = ::google::cloud::internal::StreamingReadRpcError<
      google::spanner::v1::BatchWriteResponse>;
  auto status = auth_->ConfigureContext(*context);
  if (!status.ok()) return std::make_unique<ErrorStream>(std::move(status));
  return child_->BatchWrite(std::move(context), options, request);
}

future<StatusOr<google::spanner::v1::BatchCreateSessionsResponse>>
SpannerAuth::AsyncBatchCreateSessions(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::spanner::v1::BatchCreateSessionsRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(
              StatusOr<google::spanner::v1::BatchCreateSessionsResponse>(
                  std::move(context).status()));
        }
        return child->AsyncBatchCreateSessions(cq, *std::move(context),
                                               std::move(options), request);
      });
}

future<Status> SpannerAuth::AsyncDeleteSession(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::spanner::v1::DeleteSessionRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncDeleteSession(cq, *std::move(context),
                                         std::move(options), request);
      });
}

future<StatusOr<google::spanner::v1::ResultSet>> SpannerAuth::AsyncExecuteSql(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::spanner::v1::ExecuteSqlRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(StatusOr<google::spanner::v1::ResultSet>(
              std::move(context).status()));
        }
        return child->AsyncExecuteSql(cq, *std::move(context),
                                      std::move(options), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace spanner_internal
}  // namespace cloud
}  // namespace google
