// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/storageinsights/v1/storageinsights.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGEINSIGHTS_V1_MOCKS_MOCK_STORAGE_INSIGHTS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGEINSIGHTS_V1_MOCKS_MOCK_STORAGE_INSIGHTS_CONNECTION_H

#include "google/cloud/storageinsights/v1/storage_insights_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace storageinsights_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `StorageInsightsConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `StorageInsightsClient`. To do so,
 * construct an object of type `StorageInsightsClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockStorageInsightsConnection
    : public storageinsights_v1::StorageInsightsConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::storageinsights::v1::ReportConfig>),
      ListReportConfigs,
      (google::cloud::storageinsights::v1::ListReportConfigsRequest request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::storageinsights::v1::ReportConfig>,
              GetReportConfig,
              (google::cloud::storageinsights::v1::GetReportConfigRequest const&
                   request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::storageinsights::v1::ReportConfig>,
      CreateReportConfig,
      (google::cloud::storageinsights::v1::CreateReportConfigRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::storageinsights::v1::ReportConfig>,
      UpdateReportConfig,
      (google::cloud::storageinsights::v1::UpdateReportConfigRequest const&
           request),
      (override));

  MOCK_METHOD(
      Status, DeleteReportConfig,
      (google::cloud::storageinsights::v1::DeleteReportConfigRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::storageinsights::v1::ReportDetail>),
      ListReportDetails,
      (google::cloud::storageinsights::v1::ListReportDetailsRequest request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::storageinsights::v1::ReportDetail>,
              GetReportDetail,
              (google::cloud::storageinsights::v1::GetReportDetailRequest const&
                   request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storageinsights_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGEINSIGHTS_V1_MOCKS_MOCK_STORAGE_INSIGHTS_CONNECTION_H
