// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/talent/v4/company_service.proto

#include "google/cloud/talent/v4/internal/company_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace talent_v4_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CompanyServiceTracingStub::CompanyServiceTracingStub(
    std::shared_ptr<CompanyServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceTracingStub::CreateCompany(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::CreateCompanyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.CompanyService",
                                     "CreateCompany");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateCompany(context, options, request));
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceTracingStub::GetCompany(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::GetCompanyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.CompanyService",
                                     "GetCompany");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCompany(context, options, request));
}

StatusOr<google::cloud::talent::v4::Company>
CompanyServiceTracingStub::UpdateCompany(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::UpdateCompanyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.CompanyService",
                                     "UpdateCompany");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateCompany(context, options, request));
}

Status CompanyServiceTracingStub::DeleteCompany(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::DeleteCompanyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.CompanyService",
                                     "DeleteCompany");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteCompany(context, options, request));
}

StatusOr<google::cloud::talent::v4::ListCompaniesResponse>
CompanyServiceTracingStub::ListCompanies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::talent::v4::ListCompaniesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.talent.v4.CompanyService",
                                     "ListCompanies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCompanies(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<CompanyServiceStub> MakeCompanyServiceTracingStub(
    std::shared_ptr<CompanyServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<CompanyServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace talent_v4_internal
}  // namespace cloud
}  // namespace google
