// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/timeseriesinsights/v1/timeseries_insights.proto

#include "google/cloud/timeseriesinsights/v1/internal/timeseries_insights_controller_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace timeseriesinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TimeseriesInsightsControllerTracingStub::
    TimeseriesInsightsControllerTracingStub(
        std::shared_ptr<TimeseriesInsightsControllerStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::timeseriesinsights::v1::ListDataSetsResponse>
TimeseriesInsightsControllerTracingStub::ListDataSets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::timeseriesinsights::v1::ListDataSetsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.timeseriesinsights.v1.TimeseriesInsightsController",
      "ListDataSets");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDataSets(context, options, request));
}

StatusOr<google::cloud::timeseriesinsights::v1::DataSet>
TimeseriesInsightsControllerTracingStub::CreateDataSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::timeseriesinsights::v1::CreateDataSetRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.timeseriesinsights.v1.TimeseriesInsightsController",
      "CreateDataSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateDataSet(context, options, request));
}

Status TimeseriesInsightsControllerTracingStub::DeleteDataSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::timeseriesinsights::v1::DeleteDataSetRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.timeseriesinsights.v1.TimeseriesInsightsController",
      "DeleteDataSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteDataSet(context, options, request));
}

StatusOr<google::cloud::timeseriesinsights::v1::AppendEventsResponse>
TimeseriesInsightsControllerTracingStub::AppendEvents(
    grpc::ClientContext& context, Options const& options,
    google::cloud::timeseriesinsights::v1::AppendEventsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.timeseriesinsights.v1.TimeseriesInsightsController",
      "AppendEvents");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->AppendEvents(context, options, request));
}

StatusOr<google::cloud::timeseriesinsights::v1::QueryDataSetResponse>
TimeseriesInsightsControllerTracingStub::QueryDataSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::timeseriesinsights::v1::QueryDataSetRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.timeseriesinsights.v1.TimeseriesInsightsController",
      "QueryDataSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->QueryDataSet(context, options, request));
}

StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice>
TimeseriesInsightsControllerTracingStub::EvaluateSlice(
    grpc::ClientContext& context, Options const& options,
    google::cloud::timeseriesinsights::v1::EvaluateSliceRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.timeseriesinsights.v1.TimeseriesInsightsController",
      "EvaluateSlice");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->EvaluateSlice(context, options, request));
}

StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice>
TimeseriesInsightsControllerTracingStub::EvaluateTimeseries(
    grpc::ClientContext& context, Options const& options,
    google::cloud::timeseriesinsights::v1::EvaluateTimeseriesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.timeseriesinsights.v1.TimeseriesInsightsController",
      "EvaluateTimeseries");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->EvaluateTimeseries(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<TimeseriesInsightsControllerStub>
MakeTimeseriesInsightsControllerTracingStub(
    std::shared_ptr<TimeseriesInsightsControllerStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<TimeseriesInsightsControllerTracingStub>(
      std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace timeseriesinsights_v1_internal
}  // namespace cloud
}  // namespace google
