// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#include "google/cloud/translate/v3/internal/translation_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace translate_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TranslationServiceTracingConnection::TranslationServiceTracingConnection(
    std::shared_ptr<translate_v3::TranslationServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::translation::v3::TranslateTextResponse>
TranslationServiceTracingConnection::TranslateText(
    google::cloud::translation::v3::TranslateTextRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::TranslateText");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TranslateText(request));
}

StatusOr<google::cloud::translation::v3::RomanizeTextResponse>
TranslationServiceTracingConnection::RomanizeText(
    google::cloud::translation::v3::RomanizeTextRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::RomanizeText");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RomanizeText(request));
}

StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
TranslationServiceTracingConnection::DetectLanguage(
    google::cloud::translation::v3::DetectLanguageRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DetectLanguage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DetectLanguage(request));
}

StatusOr<google::cloud::translation::v3::SupportedLanguages>
TranslationServiceTracingConnection::GetSupportedLanguages(
    google::cloud::translation::v3::GetSupportedLanguagesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::GetSupportedLanguages");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSupportedLanguages(request));
}

StatusOr<google::cloud::translation::v3::TranslateDocumentResponse>
TranslationServiceTracingConnection::TranslateDocument(
    google::cloud::translation::v3::TranslateDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::TranslateDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TranslateDocument(request));
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
TranslationServiceTracingConnection::BatchTranslateText(
    google::cloud::translation::v3::BatchTranslateTextRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::BatchTranslateText");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchTranslateText(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::BatchTranslateText(
    NoAwaitTag,
    google::cloud::translation::v3::BatchTranslateTextRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::BatchTranslateText");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->BatchTranslateText(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
TranslationServiceTracingConnection::BatchTranslateText(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::BatchTranslateText");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchTranslateText(operation));
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
TranslationServiceTracingConnection::BatchTranslateDocument(
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::BatchTranslateDocument");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchTranslateDocument(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::BatchTranslateDocument(
    NoAwaitTag,
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::BatchTranslateDocument");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->BatchTranslateDocument(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
TranslationServiceTracingConnection::BatchTranslateDocument(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::BatchTranslateDocument");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->BatchTranslateDocument(operation));
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceTracingConnection::CreateGlossary(
    google::cloud::translation::v3::CreateGlossaryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateGlossary");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateGlossary(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::CreateGlossary(
    NoAwaitTag,
    google::cloud::translation::v3::CreateGlossaryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateGlossary");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateGlossary(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceTracingConnection::CreateGlossary(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateGlossary");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateGlossary(operation));
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceTracingConnection::UpdateGlossary(
    google::cloud::translation::v3::UpdateGlossaryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::UpdateGlossary");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateGlossary(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::UpdateGlossary(
    NoAwaitTag,
    google::cloud::translation::v3::UpdateGlossaryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::UpdateGlossary");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateGlossary(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceTracingConnection::UpdateGlossary(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::UpdateGlossary");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateGlossary(operation));
}

StreamRange<google::cloud::translation::v3::Glossary>
TranslationServiceTracingConnection::ListGlossaries(
    google::cloud::translation::v3::ListGlossariesRequest request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ListGlossaries");
  internal::OTelScope scope(span);
  auto sr = child_->ListGlossaries(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::translation::v3::Glossary>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::translation::v3::Glossary>
TranslationServiceTracingConnection::GetGlossary(
    google::cloud::translation::v3::GetGlossaryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::GetGlossary");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGlossary(request));
}

future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
TranslationServiceTracingConnection::DeleteGlossary(
    google::cloud::translation::v3::DeleteGlossaryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteGlossary");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteGlossary(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::DeleteGlossary(
    NoAwaitTag,
    google::cloud::translation::v3::DeleteGlossaryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteGlossary");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteGlossary(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
TranslationServiceTracingConnection::DeleteGlossary(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteGlossary");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteGlossary(operation));
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceTracingConnection::GetGlossaryEntry(
    google::cloud::translation::v3::GetGlossaryEntryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::GetGlossaryEntry");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGlossaryEntry(request));
}

StreamRange<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceTracingConnection::ListGlossaryEntries(
    google::cloud::translation::v3::ListGlossaryEntriesRequest request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ListGlossaryEntries");
  internal::OTelScope scope(span);
  auto sr = child_->ListGlossaryEntries(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::translation::v3::GlossaryEntry>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceTracingConnection::CreateGlossaryEntry(
    google::cloud::translation::v3::CreateGlossaryEntryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateGlossaryEntry");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateGlossaryEntry(request));
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceTracingConnection::UpdateGlossaryEntry(
    google::cloud::translation::v3::UpdateGlossaryEntryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::UpdateGlossaryEntry");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateGlossaryEntry(request));
}

Status TranslationServiceTracingConnection::DeleteGlossaryEntry(
    google::cloud::translation::v3::DeleteGlossaryEntryRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteGlossaryEntry");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteGlossaryEntry(request));
}

future<StatusOr<google::cloud::translation::v3::Dataset>>
TranslationServiceTracingConnection::CreateDataset(
    google::cloud::translation::v3::CreateDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateDataset");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateDataset(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::CreateDataset(
    NoAwaitTag,
    google::cloud::translation::v3::CreateDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateDataset");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateDataset(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::Dataset>>
TranslationServiceTracingConnection::CreateDataset(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateDataset");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateDataset(operation));
}

StatusOr<google::cloud::translation::v3::Dataset>
TranslationServiceTracingConnection::GetDataset(
    google::cloud::translation::v3::GetDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::GetDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDataset(request));
}

StreamRange<google::cloud::translation::v3::Dataset>
TranslationServiceTracingConnection::ListDatasets(
    google::cloud::translation::v3::ListDatasetsRequest request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ListDatasets");
  internal::OTelScope scope(span);
  auto sr = child_->ListDatasets(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::translation::v3::Dataset>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
TranslationServiceTracingConnection::DeleteDataset(
    google::cloud::translation::v3::DeleteDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteDataset");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteDataset(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::DeleteDataset(
    NoAwaitTag,
    google::cloud::translation::v3::DeleteDatasetRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteDataset");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteDataset(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
TranslationServiceTracingConnection::DeleteDataset(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteDataset");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteDataset(operation));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceTracingConnection::CreateAdaptiveMtDataset(
    google::cloud::translation::v3::CreateAdaptiveMtDatasetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateAdaptiveMtDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateAdaptiveMtDataset(request));
}

Status TranslationServiceTracingConnection::DeleteAdaptiveMtDataset(
    google::cloud::translation::v3::DeleteAdaptiveMtDatasetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteAdaptiveMtDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteAdaptiveMtDataset(request));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceTracingConnection::GetAdaptiveMtDataset(
    google::cloud::translation::v3::GetAdaptiveMtDatasetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::GetAdaptiveMtDataset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAdaptiveMtDataset(request));
}

StreamRange<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceTracingConnection::ListAdaptiveMtDatasets(
    google::cloud::translation::v3::ListAdaptiveMtDatasetsRequest request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ListAdaptiveMtDatasets");
  internal::OTelScope scope(span);
  auto sr = child_->ListAdaptiveMtDatasets(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::translation::v3::AdaptiveMtDataset>(std::move(span),
                                                         std::move(sr));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtTranslateResponse>
TranslationServiceTracingConnection::AdaptiveMtTranslate(
    google::cloud::translation::v3::AdaptiveMtTranslateRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::AdaptiveMtTranslate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->AdaptiveMtTranslate(request));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceTracingConnection::GetAdaptiveMtFile(
    google::cloud::translation::v3::GetAdaptiveMtFileRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::GetAdaptiveMtFile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAdaptiveMtFile(request));
}

Status TranslationServiceTracingConnection::DeleteAdaptiveMtFile(
    google::cloud::translation::v3::DeleteAdaptiveMtFileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteAdaptiveMtFile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteAdaptiveMtFile(request));
}

StatusOr<google::cloud::translation::v3::ImportAdaptiveMtFileResponse>
TranslationServiceTracingConnection::ImportAdaptiveMtFile(
    google::cloud::translation::v3::ImportAdaptiveMtFileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ImportAdaptiveMtFile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ImportAdaptiveMtFile(request));
}

StreamRange<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceTracingConnection::ListAdaptiveMtFiles(
    google::cloud::translation::v3::ListAdaptiveMtFilesRequest request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ListAdaptiveMtFiles");
  internal::OTelScope scope(span);
  auto sr = child_->ListAdaptiveMtFiles(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::translation::v3::AdaptiveMtFile>(std::move(span),
                                                      std::move(sr));
}

StreamRange<google::cloud::translation::v3::AdaptiveMtSentence>
TranslationServiceTracingConnection::ListAdaptiveMtSentences(
    google::cloud::translation::v3::ListAdaptiveMtSentencesRequest request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ListAdaptiveMtSentences");
  internal::OTelScope scope(span);
  auto sr = child_->ListAdaptiveMtSentences(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::translation::v3::AdaptiveMtSentence>(std::move(span),
                                                          std::move(sr));
}

future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
TranslationServiceTracingConnection::ImportData(
    google::cloud::translation::v3::ImportDataRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ImportData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ImportData(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::ImportData(
    NoAwaitTag,
    google::cloud::translation::v3::ImportDataRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ImportData");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->ImportData(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
TranslationServiceTracingConnection::ImportData(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ImportData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ImportData(operation));
}

future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
TranslationServiceTracingConnection::ExportData(
    google::cloud::translation::v3::ExportDataRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ExportData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ExportData(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::ExportData(
    NoAwaitTag,
    google::cloud::translation::v3::ExportDataRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ExportData");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->ExportData(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
TranslationServiceTracingConnection::ExportData(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ExportData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ExportData(operation));
}

StreamRange<google::cloud::translation::v3::Example>
TranslationServiceTracingConnection::ListExamples(
    google::cloud::translation::v3::ListExamplesRequest request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ListExamples");
  internal::OTelScope scope(span);
  auto sr = child_->ListExamples(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::translation::v3::Example>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::translation::v3::Model>>
TranslationServiceTracingConnection::CreateModel(
    google::cloud::translation::v3::CreateModelRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateModel(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::CreateModel(
    NoAwaitTag,
    google::cloud::translation::v3::CreateModelRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateModel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::Model>>
TranslationServiceTracingConnection::CreateModel(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::CreateModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateModel(operation));
}

StreamRange<google::cloud::translation::v3::Model>
TranslationServiceTracingConnection::ListModels(
    google::cloud::translation::v3::ListModelsRequest request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::ListModels");
  internal::OTelScope scope(span);
  auto sr = child_->ListModels(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::translation::v3::Model>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::translation::v3::Model>
TranslationServiceTracingConnection::GetModel(
    google::cloud::translation::v3::GetModelRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::GetModel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetModel(request));
}

future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
TranslationServiceTracingConnection::DeleteModel(
    google::cloud::translation::v3::DeleteModelRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteModel(request));
}

StatusOr<google::longrunning::Operation>
TranslationServiceTracingConnection::DeleteModel(
    NoAwaitTag,
    google::cloud::translation::v3::DeleteModelRequest const& request) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteModel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
TranslationServiceTracingConnection::DeleteModel(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "translate_v3::TranslationServiceConnection::DeleteModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteModel(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<translate_v3::TranslationServiceConnection>
MakeTranslationServiceTracingConnection(
    std::shared_ptr<translate_v3::TranslationServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<TranslationServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate_v3_internal
}  // namespace cloud
}  // namespace google
