// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/videointelligence/v1/video_intelligence.proto

#include "google/cloud/videointelligence/v1/internal/video_intelligence_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace videointelligence_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

VideoIntelligenceServiceTracingConnection::
    VideoIntelligenceServiceTracingConnection(
        std::shared_ptr<
            videointelligence_v1::VideoIntelligenceServiceConnection>
            child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::videointelligence::v1::AnnotateVideoResponse>>
VideoIntelligenceServiceTracingConnection::AnnotateVideo(
    google::cloud::videointelligence::v1::AnnotateVideoRequest const& request) {
  auto span = internal::MakeSpan(
      "videointelligence_v1::VideoIntelligenceServiceConnection::"
      "AnnotateVideo");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AnnotateVideo(request));
}

StatusOr<google::longrunning::Operation>
VideoIntelligenceServiceTracingConnection::AnnotateVideo(
    NoAwaitTag,
    google::cloud::videointelligence::v1::AnnotateVideoRequest const& request) {
  auto span = internal::MakeSpan(
      "videointelligence_v1::VideoIntelligenceServiceConnection::"
      "AnnotateVideo");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->AnnotateVideo(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::videointelligence::v1::AnnotateVideoResponse>>
VideoIntelligenceServiceTracingConnection::AnnotateVideo(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "videointelligence_v1::VideoIntelligenceServiceConnection::"
      "AnnotateVideo");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AnnotateVideo(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<videointelligence_v1::VideoIntelligenceServiceConnection>
MakeVideoIntelligenceServiceTracingConnection(
    std::shared_ptr<videointelligence_v1::VideoIntelligenceServiceConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<VideoIntelligenceServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace videointelligence_v1_internal
}  // namespace cloud
}  // namespace google
