/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class WinProcesses {
    public static Info[] getRunningProcesses() {
        Collection collection = RunningProcessChecker.getAllRunningProcesses();
        Info[] infoArray = new Info[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Misc.ProcessInfo processInfo = (Misc.ProcessInfo)iterator.next();
            infoArray[n++] = new Info(processInfo);
        }
        return infoArray;
    }

    public static boolean areInstalledLaunchersRunning() {
        if (!InstallerUtil.isWindows()) {
            return false;
        }
        return RunningProcessChecker.areInstalledLaunchersRunning();
    }

    public static String getWindowTitle(int n) {
        return Misc.getWindowTitle(n);
    }

    public static boolean terminateProcesses(int[] nArray) {
        return Misc.terminateProcesses(nArray, true, 0) == 1;
    }

    public static boolean closeProcesses(int[] nArray, int n) {
        return Misc.terminateProcesses(nArray, false, n) == 1;
    }

    public static class Info
    implements Serializable {
        private int processId;
        private String moduleName;

        private Info(Misc.ProcessInfo processInfo) {
            this.processId = processInfo.getProcessId();
            this.moduleName = processInfo.getModuleName();
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public int getProcessId() {
            return this.processId;
        }

        public String toString() {
            return "WinProcesses.Info{processId=" + this.processId + ", moduleName='" + this.moduleName + '\'' + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Info info = (Info)object;
            return this.processId == info.processId;
        }

        public int hashCode() {
            return this.processId;
        }
    }
}

