// Copyright 2022-2025 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: observability/ping/v1/ping.proto

package pingv1connect

import (
	connect "connectrpc.com/connect"
	v1 "connectrpc.com/otelconnect/internal/gen/observability/ping/v1"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// PingServiceName is the fully-qualified name of the PingService service.
	PingServiceName = "observability.ping.v1.PingService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// PingServicePingProcedure is the fully-qualified name of the PingService's Ping RPC.
	PingServicePingProcedure = "/observability.ping.v1.PingService/Ping"
	// PingServicePingStreamProcedure is the fully-qualified name of the PingService's PingStream RPC.
	PingServicePingStreamProcedure = "/observability.ping.v1.PingService/PingStream"
	// PingServiceFailProcedure is the fully-qualified name of the PingService's Fail RPC.
	PingServiceFailProcedure = "/observability.ping.v1.PingService/Fail"
)

// These variables are the protoreflect.Descriptor objects for the RPCs defined in this package.
var (
	pingServiceServiceDescriptor          = v1.File_observability_ping_v1_ping_proto.Services().ByName("PingService")
	pingServicePingMethodDescriptor       = pingServiceServiceDescriptor.Methods().ByName("Ping")
	pingServicePingStreamMethodDescriptor = pingServiceServiceDescriptor.Methods().ByName("PingStream")
	pingServiceFailMethodDescriptor       = pingServiceServiceDescriptor.Methods().ByName("Fail")
)

// PingServiceClient is a client for the observability.ping.v1.PingService service.
type PingServiceClient interface {
	// Ping sends a ping to the server to determine if it's reachable.
	Ping(context.Context, *connect.Request[v1.PingRequest]) (*connect.Response[v1.PingResponse], error)
	// PingStream sends a ful-duplex stream of pings to the server.
	PingStream(context.Context) *connect.BidiStreamForClient[v1.PingStreamRequest, v1.PingStreamResponse]
	// Fail sends a request to the server that will generate an error.
	Fail(context.Context, *connect.Request[v1.FailRequest]) (*connect.Response[v1.FailResponse], error)
}

// NewPingServiceClient constructs a client for the observability.ping.v1.PingService service. By
// default, it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses,
// and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the
// connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewPingServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) PingServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &pingServiceClient{
		ping: connect.NewClient[v1.PingRequest, v1.PingResponse](
			httpClient,
			baseURL+PingServicePingProcedure,
			connect.WithSchema(pingServicePingMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		pingStream: connect.NewClient[v1.PingStreamRequest, v1.PingStreamResponse](
			httpClient,
			baseURL+PingServicePingStreamProcedure,
			connect.WithSchema(pingServicePingStreamMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
		fail: connect.NewClient[v1.FailRequest, v1.FailResponse](
			httpClient,
			baseURL+PingServiceFailProcedure,
			connect.WithSchema(pingServiceFailMethodDescriptor),
			connect.WithClientOptions(opts...),
		),
	}
}

// pingServiceClient implements PingServiceClient.
type pingServiceClient struct {
	ping       *connect.Client[v1.PingRequest, v1.PingResponse]
	pingStream *connect.Client[v1.PingStreamRequest, v1.PingStreamResponse]
	fail       *connect.Client[v1.FailRequest, v1.FailResponse]
}

// Ping calls observability.ping.v1.PingService.Ping.
func (c *pingServiceClient) Ping(ctx context.Context, req *connect.Request[v1.PingRequest]) (*connect.Response[v1.PingResponse], error) {
	return c.ping.CallUnary(ctx, req)
}

// PingStream calls observability.ping.v1.PingService.PingStream.
func (c *pingServiceClient) PingStream(ctx context.Context) *connect.BidiStreamForClient[v1.PingStreamRequest, v1.PingStreamResponse] {
	return c.pingStream.CallBidiStream(ctx)
}

// Fail calls observability.ping.v1.PingService.Fail.
func (c *pingServiceClient) Fail(ctx context.Context, req *connect.Request[v1.FailRequest]) (*connect.Response[v1.FailResponse], error) {
	return c.fail.CallUnary(ctx, req)
}

// PingServiceHandler is an implementation of the observability.ping.v1.PingService service.
type PingServiceHandler interface {
	// Ping sends a ping to the server to determine if it's reachable.
	Ping(context.Context, *connect.Request[v1.PingRequest]) (*connect.Response[v1.PingResponse], error)
	// PingStream sends a ful-duplex stream of pings to the server.
	PingStream(context.Context, *connect.BidiStream[v1.PingStreamRequest, v1.PingStreamResponse]) error
	// Fail sends a request to the server that will generate an error.
	Fail(context.Context, *connect.Request[v1.FailRequest]) (*connect.Response[v1.FailResponse], error)
}

// NewPingServiceHandler builds an HTTP handler from the service implementation. It returns the path
// on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewPingServiceHandler(svc PingServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	pingServicePingHandler := connect.NewUnaryHandler(
		PingServicePingProcedure,
		svc.Ping,
		connect.WithSchema(pingServicePingMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	pingServicePingStreamHandler := connect.NewBidiStreamHandler(
		PingServicePingStreamProcedure,
		svc.PingStream,
		connect.WithSchema(pingServicePingStreamMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	pingServiceFailHandler := connect.NewUnaryHandler(
		PingServiceFailProcedure,
		svc.Fail,
		connect.WithSchema(pingServiceFailMethodDescriptor),
		connect.WithHandlerOptions(opts...),
	)
	return "/observability.ping.v1.PingService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case PingServicePingProcedure:
			pingServicePingHandler.ServeHTTP(w, r)
		case PingServicePingStreamProcedure:
			pingServicePingStreamHandler.ServeHTTP(w, r)
		case PingServiceFailProcedure:
			pingServiceFailHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedPingServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedPingServiceHandler struct{}

func (UnimplementedPingServiceHandler) Ping(context.Context, *connect.Request[v1.PingRequest]) (*connect.Response[v1.PingResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("observability.ping.v1.PingService.Ping is not implemented"))
}

func (UnimplementedPingServiceHandler) PingStream(context.Context, *connect.BidiStream[v1.PingStreamRequest, v1.PingStreamResponse]) error {
	return connect.NewError(connect.CodeUnimplemented, errors.New("observability.ping.v1.PingService.PingStream is not implemented"))
}

func (UnimplementedPingServiceHandler) Fail(context.Context, *connect.Request[v1.FailRequest]) (*connect.Response[v1.FailResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("observability.ping.v1.PingService.Fail is not implemented"))
}
